import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.prefs.Preferences;

class equalizer_options_dialogc extends JDialog implements
ActionListener {
  Preferences prefs;
  JSpinner min_spinner;
  JSpinner max_spinner;
  JSpinner sample_rate_spinner;
  JComboBox window_function_combobox;
  String[] window_function_names = {"Rectangular","Triangular","Parzen","Welch","Cosine","Hanning","Gaussian"};
  boolean ok = false;
  equalizer_options_dialogc(Frame owner,Preferences prefs) {
    super(owner,"options",true);
    this.prefs = prefs;
    this.getContentPane().setLayout(new BoxLayout( this.getContentPane(), BoxLayout.PAGE_AXIS));    
    SpinnerNumberModel nm;
    int min = prefs.getInt("min",-60);
    nm = new SpinnerNumberModel(min,-60,0,1);
    min_spinner = create_spinner("min",nm);
    int max = prefs.getInt("max",60);
    nm = new SpinnerNumberModel(max,0,60,1);
    max_spinner = create_spinner("max",nm);

    int sample_rate = prefs.getInt("sample_rate",48000);
    nm = new SpinnerNumberModel(sample_rate,8000,192000,100);
    sample_rate_spinner = create_spinner("sample_rate",nm);


    JPanel win_func_panel = new JPanel();
    win_func_panel.setLayout(new GridLayout(1,2));
    win_func_panel.add(new JLabel("window: "));
    window_function_combobox = new JComboBox(window_function_names);
    int i = prefs.getInt("window_function_index",0);
    window_function_combobox.setSelectedIndex(i);

    win_func_panel.add(window_function_combobox);
    this.getContentPane().add(win_func_panel);

    JPanel button_panel = new JPanel();
    button_panel.setLayout(new GridLayout(1,2));
    button_panel.add(create_button("ok"));
    button_panel.add(create_button("cancel"));
    this.getContentPane().add(button_panel);
    this.pack();
  }
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    if (action.equals("ok")) {
      Number min = (Number) min_spinner.getValue();
      Number max = (Number) max_spinner.getValue();
      //int max = n.intValue();
      prefs.putInt("min",min.intValue());
      prefs.putInt("max",max.intValue());

      Number sr = (Number) sample_rate_spinner.getValue();
      prefs.putInt("sample_rate",sr.intValue());
      this.setVisible(false);
      int i = window_function_combobox.getSelectedIndex();
      prefs.putInt("window_function_index",i);
      equalizerc.window_function = i;
      ok = true;
    }
    if (action.equals("cancel")) {
      this.setVisible(false);
    }
  }
  public JButton create_button(String text) {
    JButton b = new JButton(text);
    b.addActionListener(this);
    b.setActionCommand(text);
    return b;
  }
  public JSpinner create_spinner(String text,SpinnerNumberModel m) {
    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(1,2));
    //panel.setLayout(new FlowLayout());
    panel.add(new JLabel(text));
    JSpinner sp = new JSpinner(m);
    //sp.addChangeListener(this);
    panel.add(sp);
    this.getContentPane().add(panel);
    return sp;
  }
}
public class equalizer_windowc extends JFrame implements ActionListener,ChangeListener, Runnable {
  //JSlider freq_slider[];
  Vector<JSlider> freq_slider_vec;
  //int band_db[];
  //float FFT_data[][];
  //float filter43[];
  //float buffer_in[][];
  //float buffer_out[][];
  static Preferences prefs = lsystems_app.prefs.node("equalizer");
  static boolean eq_enabled = prefs.getBoolean("enabled",true);
  static int num_bands = prefs.getInt("num_bands",12);
  static int num_bands2 = prefs.getInt("num_bands",12);
  static int offset = prefs.getInt("offset",0);
  //Preferences prefs = Preferences.userRoot().node("noise_equalizer3252354379798579393");
  //noise_maker nm;
  static boolean eq_changed = true;
  JCheckBoxMenuItem enable_eq_menu_item;
  GridLayout gl;
  JMenuBar main_menu_bar;
  int window_function_index;
  equalizer_windowc() {
    int nb = prefs.getInt("num_bands",12);
    //offset = prefs.getInt("offset",0);
    window_function_index = prefs.getInt("window_function_index",0);

    //num_bands = nb;
    //band_db = new int[num_bands];
    //prefs = Preferences.userRoot().node("ca1d_equalizer3799245");
    freq_slider_vec = new Vector();
    //freq_slider = new JSlider[num_bands];
    gl = new GridLayout(1,1);
    this.getContentPane().setLayout(gl);    
    num_bands = 0;
    for (int i = 0;i < nb;i++) {
      //JSlider sl = new JSlider(-60,60,0);
      //freq_slider_vec.add(sl);
      add_slider(true);
    }
    main_menu_bar = setup_menu();
    setJMenuBar(main_menu_bar);
    this.pack();
    //nm = new noise_maker(this);
    //nm.start();
  }
  JCheckBoxMenuItem createCheckBoxMenuItem(String text,JMenu menu,String action) {
    JCheckBoxMenuItem mi = new JCheckBoxMenuItem(text);
    menu.add(mi);
    mi.setActionCommand(action);    
    mi.addActionListener(this);
    return mi;
  }
  JMenuItem createMenuItem(String text,JMenu menu,String action) {
    JMenuItem mi = new JMenuItem(text);
    menu.add(mi);
    mi.setActionCommand(action);    
    mi.addActionListener(this);
    return mi;
  }
  JMenuBar setup_menu() { 
    JMenuBar mb = new JMenuBar();
    JMenu eq_menu = new JMenu("equalizer");
    enable_eq_menu_item = createCheckBoxMenuItem("enable",eq_menu,"enable");
    enable_eq_menu_item.setSelected(eq_enabled);
    createMenuItem("add left",eq_menu,"add_l");
    createMenuItem("remove left",eq_menu,"remove_l");
    createMenuItem("add right",eq_menu,"add_r");
    createMenuItem("remove right",eq_menu,"remove_r");
    createMenuItem("options",eq_menu,"options");

    mb.add(eq_menu);
    return mb;

  }
  static int[] get_band_db_array() {
    //System.out.println("nb: " + num_bands);
    int b[] = new int[num_bands];
    for (int i = 0;i < num_bands;i++) {
      int i2 = i+offset;
      b[i] = prefs.getInt("band"+i2,0);   
    }
    return b;
  }
  //void shift_left() {
  //  for (int i = 0;i < num_bands;i++) {
  //    JSlider sl = freq_slider_vec.get(i);
  //    int i1 = i + 1;
  //    int db = 0;
      //if (i1 < num_bands) {
  //      db = prefs.getInt("band"+i1,0);      
      //}
  //    sl.setValue(db);
  //  }
  //}
  //void shift_right() {
  //  for (int i = num_bands-1;i >= 0;i--) {
  //    JSlider sl = freq_slider_vec.get(i);
  //    int i1 = i - 1;
  //    int db = 0;
      //if (i1 < num_bands) {
  //      db = prefs.getInt("band"+i1,0);      
      //}
  //    sl.setValue(db);
  //  }
  //}
  void remove_slider(boolean e) {
      num_bands = num_bands - 1;
      //int i = 0;
      if (e == true) {
        this.getContentPane().remove(num_bands);
        freq_slider_vec.remove(num_bands);
      } else {
        this.getContentPane().remove(0);
        freq_slider_vec.remove(0);
        offset = offset + 1;
      }
      this.validate();
  }

  void add_slider(boolean e) {
      int i = 0;
      int min = prefs.getInt("min",-60);
      int max = prefs.getInt("max",60);
      if (e == true) {i = num_bands;}
      else {offset = offset - 1;}
      i = i + offset;
      JSlider sl = new JSlider(min,max,0);
      int db = prefs.getInt("band"+i,0);      
      sl.setEnabled(eq_enabled);
      sl.setValue(db);
      sl.setOrientation(SwingConstants.VERTICAL);
      sl.setMajorTickSpacing(10);
      sl.setMinorTickSpacing(1);
      sl.setSnapToTicks(true);
      sl.setPaintTicks(true);
      sl.addChangeListener(this);
      if (e) {
        this.getContentPane().add(sl);
        freq_slider_vec.add(sl);
      } else {
        this.getContentPane().add(sl,0);
        freq_slider_vec.add(0,sl);
      }
      num_bands = num_bands + 1;
      gl.setColumns(num_bands);
      this.validate();
  }
  public static void main(String[] args){
    javax.swing.SwingUtilities.invokeLater(new equalizer_windowc());    
  }

  public void stateChanged(ChangeEvent e) {
    for (int i = 0;i < num_bands;i++) {
      JSlider sl = freq_slider_vec.get(i);
      if (e.getSource() == sl) {

        int db = sl.getValue();
        //band_db[i] = db;
        int i2 = i+offset;
        prefs.putInt("band"+i2,db);      
        eq_changed = true;
        //wave_app.update_data();
        //wave_app.wave_main_window.wave_main_panel.repaint();
      }
    }
  }

  //void update_filter43() {

  //}
  public void run() {
    this.setVisible(true);
  }
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    if (action.equals("enable")) {
      boolean b = enable_eq_menu_item.isSelected();
      for (int i = 0;i < num_bands;i++) {
        JSlider sl = freq_slider_vec.get(i);
        sl.setEnabled(b);
      }
      eq_enabled = b;
      prefs.putBoolean("enabled",b);
      //System.out.println("e " + b);
      //b = !b;
      //System.out.println("e " + b);
    }
    if (action.equals("add_l")) {
      //prefs.putInt("band",db);
      add_slider(false);
      num_bands2 = num_bands;
      prefs.putInt("num_bands",num_bands);
      prefs.putInt("offset",offset);

      //update_slider()
      //shift_right();
    }
    if (action.equals("remove_l")) {
      //shift_left();
      remove_slider(false);
      num_bands2 = num_bands;
      prefs.putInt("num_bands",num_bands);
      prefs.putInt("offset",offset);
    }
    if (action.equals("add_r")) {
      add_slider(true);
      num_bands2 = num_bands;
      prefs.putInt("num_bands",num_bands);

      //shift_left();
    }
    if (action.equals("remove_r")) {
      remove_slider(true);
      num_bands2 = num_bands;
      prefs.putInt("num_bands",num_bands);
      //shift_right();
    }
    if (action.equals("options")) {
      equalizer_options_dialogc d = new equalizer_options_dialogc(this,prefs);
      d.setVisible(true);
      if (d.ok == true) {        
        if (window_function_index != prefs.getInt("window_function_index",0)) {
          eq_changed = true;
          window_function_index = prefs.getInt("window_function_index",0);
        }
        int min = prefs.getInt("min",-60);
        int max = prefs.getInt("max",60);
        for (int i = 0;i < freq_slider_vec.size();i++) {
          JSlider sl = freq_slider_vec.get(i);
          int v = sl.getValue();
          if (v < min) {v = min;}
          if (v > max) {v = max;}
          sl.setValue(v);
          sl.setMinimum(min);
          sl.setMaximum(max);
        }
      }
    }
  }
}


