import java.util.prefs.Preferences;
public class equalizerc {
  float FFT_data[][];
  float filter43[];
  float buffer_in[][];
  float buffer_out[][];
  int index = 0;
  int num_bands;
  static Preferences prefs = Preferences.userRoot().node("lsystems_34987534").node("equalizer");
  static int window_function = prefs.getInt("window_function_index",0);
  static int Rectangular_WINDOW = 0;
  static int Triangular_WINDOW = 1;
  static int Parzen_WINDOW = 2;
  static int Welch_WINDOW = 3;
  static int Cosine_WINDOW = 4;
  static int Hanning_WINDOW = 5;
  static int Gaussian_WINDOW = 6;
  equalizerc(int nb) {
    num_bands = nb;
    FFT_data = new float[1 << nb][2];
    filter43 = new float[(1 << (nb-1))+1];
    buffer_in = new float[1 << (nb-1)][2];
    buffer_out = new float[1 << nb][2];
  }
  public float get_vol(int freq,int band_db[]) {
    float l = (float) (Math.log(freq)/Math.log(2));
    int o = (int) l;
    float f = l-o;
    float db = band_db[o+1] * f;
    db = db + (band_db[o] * (1.0f-f));
    return get_db_value(db);
  }
  public float get_db_value(float db) {
    return (float) (Math.exp(Math.log(10) * (db/20.0))); // Math.sqrt(freq));
  }
  void update_filter(int band_db[]) {
    int l = FFT_data.length;
    //for (int i = 0;i < num_bands;i++) {
    //  System.out.print(band_db[i] + " ");
    //}
    for (int i = 0;i < l;i++) {
      FFT_data[i][0] = 0.0f;
      FFT_data[i][1] = 0.0f;
    }
    //FFT_data[0][0] = get_vol(1)*0.5;
    //FFT_data[512][0] = get_vol(1)*0.5;
    for (int i = 1;i < (l >> 1);i++) {
      FFT_data[i][0] = get_vol(i,band_db);
      FFT_data[l-i][0] = get_vol(i,band_db);
    }
    FFT_data[0][0] = FFT_data[1][0];
    FFT_data[(l >> 1)][0] = get_db_value(band_db[num_bands-1]);

    FFT_Transformc.perform(FFT_data,true);
    for (int i = 0;i < l;i++) {
      FFT_data[i][0] *= 1.0f / (l*l);//0.0000001;
      FFT_data[i][1] = 0;
    }
    if (window_function == Triangular_WINDOW) {
      for (int i = 1;i < (l >> 2);i++) {
        float f = i;
        f = 1.0f - (f / (l >> 2));
        FFT_data[i][0] *= f;
        FFT_data[l-i][0] *= f;
      }
    }
    if (window_function == Parzen_WINDOW) { 
      for (int i = 1;i < (l >> 2);i++) {
        float f = i;
        f = f / (l >> 2);
        if (f < 0.5) {
          f = (1-(6*f*f*(1-f)));
        } else {
          f = (2*((1-f)*(1-f)*(1-f)));
        }
        FFT_data[i][0] *= f;
        FFT_data[l-i][0] *= f;
      }
    }
    if (window_function == Welch_WINDOW) {
      for (int i = 1;i < (l >> 2);i++) {
        float f = i;
        f = f / (l >> 2);
        f = 1 - (f*f);
        FFT_data[i][0] *= f;
        FFT_data[l-i][0] *= f;
      }
    }
    if (window_function == Cosine_WINDOW) {
      for (int i = 1;i < (l >> 2);i++) {
        float f = i;
        f = (float) Math.cos((f*Math.PI)/((l >> 2)*2));
        FFT_data[i][0] *= f;
        FFT_data[l-i][0] *= f;      
      }
    }
    if (window_function == Hanning_WINDOW) {
      for (int i = 1;i < (l >> 2);i++) {
        float f = i;
        f = (float) Math.cos((f*Math.PI)/((l >> 2)*2));
        f = f * f;
        FFT_data[i][0] *= f;
        FFT_data[l-i][0] *= f;      
      }
    }
    if (window_function == Gaussian_WINDOW) {
      float a = 3.0f;
      float b = (float) Math.exp(-a*a);
      for (int i = 1;i < (l >> 2);i++) {
        float f = i;
      //f = 1.0 - (f / (l >> 2));
        f = ((f*a) / (l >> 2));
        f = (float) (Math.exp(-f*f)-b);
        FFT_data[i][0] *= f;
        FFT_data[l-i][0] *= f;
      } 
    }
    for (int i = (l >> 2);i <= (l-(l >> 2));i++) {
      FFT_data[i][0] = 0.0f;
    }
    FFT_Transformc.perform(FFT_data,false);
    for (int i = 0;i <= (l >> 1);i++) {
      filter43[i] = FFT_data[i][0];
      //if (i < 100) {
      //  System.out.print(filter43[i]);
      //  System.out.print(" ");
      //}
    }    
    //System.out.println(" ");

  }
  void filter1(float buf[],int buf_size) {
    //filter2(buf,null,buf_size);
    int l = FFT_data.length;
    for (int i = 0;i < buf_size;i++) {
      index = (index + 1) & (l-1);
      if (index == 0) {
        for (int j = 0;j < l;j++) {
          FFT_data[j][0] = 0;
          FFT_data[j][1] = 0;
        }
        for (int j = 0;j < (l>>1);j++) {
          FFT_data[j+(l>>2)][0] = buffer_in[j][0];
          FFT_data[j+(l>>2)][1] = buffer_in[j][1];
        }
        FFT_Transformc.perform(FFT_data,false);
        FFT_data[0][0] = FFT_data[0][0] * filter43[0];
        FFT_data[0][1] = FFT_data[0][1] * filter43[0];
        for (int j = 1;j < (l>>1);j++) { 
          FFT_data[j][0] = FFT_data[j][0] * filter43[j];
          FFT_data[j][1] = FFT_data[j][1] * filter43[j];
          FFT_data[l-j][0] = FFT_data[l-j][0] * filter43[j];
          FFT_data[l-j][1] = FFT_data[l-j][1] * filter43[j];
        }
        FFT_data[l>>1][0] = FFT_data[l>>1][0] * filter43[l>>1];
        FFT_data[l>>1][1] = FFT_data[l>>1][1] * filter43[l>>1];
        FFT_Transformc.perform(FFT_data,true);
        for (int j = 0;j < (l>>1);j++) {
          int l2 = (l>>1);
          buffer_out[j][0] = buffer_out[j][1];
          buffer_out[j+l2][0] = buffer_out[j+l2][1] + FFT_data[j][0]; 
          buffer_out[j][1]    = FFT_data[j+l2][0] + FFT_data[j][1]; 
          buffer_out[j+l2][1] = FFT_data[j+l2][1];
        }
      }
      int l2 = l>>1;
      buffer_in[index & (l2-1)][index / l2] = buf[i];
      buf[i] = buffer_out[index][0];
    }
  }
  void filter2(float buf0[],float buf1[],int buf_size) {
    int l = FFT_data.length;
    for (int i = 0;i < buf_size;i++) {
      index = (index + 1) & ((l>>1)-1);
      if (index == 0) {
        //if (eq_changed == true) {
        //  update_filter43();
        //  eq_changed = false;
        //}
        for (int j = 0;j < l;j++) {
          FFT_data[j][0] = 0;
          FFT_data[j][1] = 0;
        }
        for (int j = 0;j < (l>>1);j++) {
          FFT_data[j+(l>>2)][0] = buffer_in[j][0];
          FFT_data[j+(l>>2)][1] = buffer_in[j][1];
        }
        FFT_Transformc.perform(FFT_data,false);
        FFT_data[0][0] = FFT_data[0][0] * filter43[0];
        FFT_data[0][1] = FFT_data[0][1] * filter43[0];
        for (int j = 1;j < (l>>1);j++) { 
          FFT_data[j][0] = FFT_data[j][0] * filter43[j];
          FFT_data[j][1] = FFT_data[j][1] * filter43[j];
          FFT_data[l-j][0] = FFT_data[l-j][0] * filter43[j];
          FFT_data[l-j][1] = FFT_data[l-j][1] * filter43[j];
        }
        FFT_data[l>>1][0] = FFT_data[l>>1][0] * filter43[l>>1];
        FFT_data[l>>1][1] = FFT_data[l>>1][1] * filter43[l>>1];
        FFT_Transformc.perform(FFT_data,true);
        for (int j = 0;j < (l>>1);j++) {
          buffer_out[j][0] = buffer_out[j+(l>>1)][0] + FFT_data[j][0]; 
          buffer_out[j][1] = buffer_out[j+(l>>1)][1] + FFT_data[j][1]; 
          buffer_out[j+(l>>1)][0] = FFT_data[j+(l>>1)][0]; 
          buffer_out[j+(l>>1)][1] = FFT_data[j+(l>>1)][1]; 
        }
      }      
      if (buf0 != null) {
        buffer_in[index][0] = buf0[i];
        buf0[i] = buffer_out[index][0];
      }
      if (buf1 != null) {
        buffer_in[index][1] = buf1[i];
        buf1[i] = buffer_out[index][1];
      }
    }
  }
}

