import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;   
import javax.swing.table.*;
      
import java.awt.*;
import java.awt.event.*;                       
import java.awt.datatransfer.*;
import java.util.prefs.Preferences;


class iso_keyboard_panel extends JPanel {
  int zoom = 20;
  int offset = 0;
  lsystems_song song;
  Fraction xgen_frac = new Fraction(); 
  Fraction ygen_frac = new Fraction(); 
  iso_keyboard_panel(lsystems_song s) {
    song = s;
  }
  long get_xgen() {
    return song.get_interval_value(xgen_frac.f());
  }
  long get_ygen() {
    return song.get_interval_value(ygen_frac.f());
  }
  protected void paintComponent(Graphics g) {
    super.paintComponent(g);
    long xgen = get_xgen();
    long ygen = get_ygen();
    int edo = song.octave;
    int w = this.getWidth();
    int h = this.getHeight();
    int w2 = w / zoom;
    int h2 = h / zoom;
    for (int x = 1;x <= w2;x++) {
      g.drawLine(x*zoom,0,x*zoom,h);
    }
    for (int y = 1;y <= h2;y++) {
      g.drawLine(0,y*zoom,w,y*zoom);
    }
    for (int x = 0;x <= w2;x++) {
      for (int y = 0;y <= h2;y++) {
        long i = ((x*xgen)+(y*ygen)+offset);
        rule_notec r = song.get_note(i);
        if (r != null) {
          g.setColor(r.get_note_color());
          g.fillRect(x*zoom,y*zoom,zoom,zoom);
        }
      }
    }
  }
  void zoom_out() {
    zoom = zoom - 1;
    if (zoom < 8) {zoom = 8;}
  }
  void zoom_in() {
    zoom = zoom + 1;
  }
}

public class iso_keyboard_window extends JFrame implements MouseListener,MouseWheelListener,KeyListener,ActionListener{
  iso_keyboard_panel panel;
  rule_notec sel_note;
  lsystems_song song;
  JTable table;
  JPanel interval_combobox_panel;
  String[] intervalStrings = {"5/8","3/4","5/6","5/4","3/2","5/3","5/2",
  "3/1","10/3","5/1","6/1","20/3"};
  String[] zoomString = {"8","10","12","14","16","20","24","28","33","40","48","57","67","80"};
  JComboBox Xcombobox;
  JComboBox Ycombobox;
  JComboBox zoom_combobox;
  Preferences prefs;
  long note_index; 
  iso_keyboard_window(lsystems_song s,JTable t) {
    super();
    String interval_str;
    prefs = lsystems_app.prefs.node("iso_keyboard_window");

    table = t;
    song = s;
    setBounds(220,20,200,200);
    interval_combobox_panel = new JPanel();
    panel = new iso_keyboard_panel(song);
    this.add(interval_combobox_panel,BorderLayout.PAGE_START);
    this.add(panel);
    Xcombobox = new JComboBox(intervalStrings);
    Ycombobox = new JComboBox(intervalStrings);
    zoom_combobox = new JComboBox(zoomString);
    interval_combobox_panel.add(new JLabel("x: "));
    interval_combobox_panel.add(Xcombobox);
    Xcombobox.addActionListener(this);
    Xcombobox.setActionCommand("x");    
    Xcombobox.setSelectedItem(prefs.get("x","3/2"));
    Xcombobox.setEditable(true);
    interval_str = (String) Xcombobox.getSelectedItem();
    panel.xgen_frac.parse_interval(interval_str);

    interval_combobox_panel.add(new JLabel("y: "));
    interval_combobox_panel.add(Ycombobox);
    Ycombobox.addActionListener(this);
    Ycombobox.setActionCommand("y");    
    Ycombobox.setSelectedItem(prefs.get("y","5/4"));
    Ycombobox.setEditable(true);
    interval_str = (String) Ycombobox.getSelectedItem();
    panel.ygen_frac.parse_interval(interval_str);

    interval_combobox_panel.add(new JLabel("zoom: "));
    interval_combobox_panel.add(zoom_combobox);
    zoom_combobox.addActionListener(this);
    zoom_combobox.setActionCommand("zoom");    
    zoom_combobox.setSelectedIndex(prefs.getInt("zoom",3));

    panel.addMouseListener(this);
    panel.addMouseWheelListener(this);
    this.addKeyListener(this);
    updateTitle();
  }
  void updateTitle() {
    this.setTitle(" iso keyboard ");
  }
  public void actionPerformed(ActionEvent ev) {        
    String action = ev.getActionCommand();
    System.out.println(action);
    if (action.equals("x")) {
      String interval_str = (String) Xcombobox.getSelectedItem();
      panel.xgen_frac.parse_interval(interval_str);
      //prefs.putInt("x",Xcombobox.getSelectedIndex());
    }
    if (action.equals("y")) {
      String interval_str = (String) Ycombobox.getSelectedItem();
      panel.ygen_frac.parse_interval(interval_str);
      //prefs.putInt("y",Ycombobox.getSelectedIndex());
    }
    if (action.equals("zoom")) {
      String zoom_str = (String) zoom_combobox.getSelectedItem();
      panel.zoom = Integer.parseInt(zoom_str);
      //prefs.putInt("zoom",zoom_combobox.getSelectedIndex());

    }
    repaint();
  }
  public void keyPressed(KeyEvent e){
    int a = e.getKeyCode();
    char ch = e.getKeyChar();  
    String s = e.getKeyText(a);
    if (ch == '-') {panel.zoom_out();}
    if (ch == '=') {panel.zoom_in();}
    repaint();
  }
  public void keyReleased(KeyEvent e){}
  public void keyTyped(KeyEvent e){}
  public void mouseWheelMoved(MouseWheelEvent e) {
    int w = e.getWheelRotation();
    panel.offset = panel.offset + w;
    repaint();
  }
  public void mouseClicked(MouseEvent e){
  }
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}
  public void mousePressed(MouseEvent e){
    //int b = e.getButton();
    int note_index2 = table.getSelectedRow();
     
    if (note_index2 >= 0) {
      sel_note = song.p_vec.get(note_index2);
    }
    note_index2 = (note_index2 + 1) % song.p_vec.size();
    //long ni = note_index;
    //for (int i = 0;i < song.p_vec.size();i++) {
    //  if ((ni & 1) == 1) {
    //    note_index2 = i;
    //    break;
    //  }
    //  ni = ni >> 1;
    //}
    //note_index++;
    table.setRowSelectionInterval(note_index2,note_index2);
    //table.setEditingRow(note_index);
  }
  public void mouseReleased(MouseEvent e){
    long xgen = panel.get_xgen();
    long ygen = panel.get_ygen();
    int edo = song.octave;
    int offset = panel.offset;
    int zoom = panel.zoom;
    long x = e.getX() / zoom;
    long y = e.getY() / zoom;
    long i = ((x*xgen)+(y*ygen)+offset)%edo;    
    if (i < 0) {i = i + edo;}
    if (sel_note != null) {
      sel_note.set_note(i);
      repaint();
    }
  }
}

