import java.lang.*;
import java.util.*;
import java.io.*;

public class lsystems_song {
  String name;
  Vector<rule_notec> p_vec;
  HashMap<String,rule_notec> hm;
  Vector<lsystems_song> song_vec;
  HashMap<String,lsystems_song> song_hm;
  rule_notec root;
  Random rand;
  int max_children = 3;
  int base = 10;
  int octave = 1200;
  int generator = 0;
  boolean modified = false;
  int num_modified = 0;
  lsystems_song parent;
  lsystems_song next;
  lsystems_song() {
    p_vec = new Vector<rule_notec>();
    song_vec = new Vector<lsystems_song>();
    hm = new HashMap<String,rule_notec>();
    song_hm = new HashMap<String,lsystems_song>();
    rand = new Random();
    base = 12;
    octave = base*base;
    parent = null;
    name = null;
  }
  lsystems_song(lsystems_song p,String n) {
    p_vec = new Vector<rule_notec>();
    song_vec = new Vector<lsystems_song>();
    hm = new HashMap<String,rule_notec>();
    song_hm = new HashMap<String,lsystems_song>();
    rand = new Random();
    parent = p;
    name = n;
    base = p.base;
    octave = p.octave;
    //interval23 = p.interval23;
    parent.song_vec.add(this);
    this.next = parent.song_hm.get(name);
    parent.song_hm.put(name,this);
  }
  int get_interval_value(float i) {
    return Math.round((float) ((Math.log(i)/Math.log(2))*octave));
  }

  void build_album(int count) {
    build_album(song_vec.size()-count, count);
  }

  rule_notec build_album(int offset,int count) {
    int p3 = max_children;
    if (count <= 1) {
      return null;
    }
    if (count <= p3) {
      rule_notec n = new rule_notec(this);
      for (int i = 0;i < count;i++) {
        n.child[i] = song_vec.get(i+offset).get_last_note();
      }
      add_rule("a" + p_vec.size(),n);
      return n;
    }
    while (count > (p3 * max_children)) {p3 = p3 * max_children;}
    int p2 = (count + max_children - 1) / p3;

    rule_notec n = new rule_notec(this);
    int r = count % p2;
    int q = count / p2;
    int o = offset;
    rule_notec ch[] = new rule_notec[p2];
    for (int i = 0;i < p2;i++) {
      if (i < r) {
        ch[i] = build_album(o,q+1);
        n.ratio[i] = q + 1;
        o = o + q + 1;
      } else {
        ch[i] = build_album(o,q);
        if (r > 0) {n.ratio[i] = q;}
        o = o + q;
      }
    }
    for (int i = 0;i < p2;i++) {
      n.child[i] = ch[i];
    }
    add_rule("a" + p_vec.size(),n);
    return n;

  }
  public lsystems_song duplicate(String n) {
    return duplicate(parent,n);
  }
  public lsystems_song duplicate(lsystems_song p,String n) {
    if (n.indexOf(".") == -1) {
      lsystems_song d = new lsystems_song(p,n);
      d.base = base;
      d.octave = octave;
      //d.interval23 = interval23;
      for (int i = 0;i < song_vec.size();i++) {
        lsystems_song s = song_vec.get(i);
        if (s != d) {s.duplicate(d,s.name);}
      }
      for (int i = 0;i < p_vec.size();i++) {
        rule_notec r = new rule_notec(p_vec.get(i));
        r.parent = d;
        d.add_rule_to_hashmap(r);
        d.p_vec.add(r);
      }
      for (int i = 0;i < p_vec.size();i++) {
        for (int ch = 0;ch < max_children;ch++) {
          rule_notec r = p_vec.get(i).child[ch];
          if (r != null) {
            String m = r.get_name(this);
            r = d.p_vec.get(i);
            r.child[ch] = d.get_rule(m);
          }
        }
      }
      return d;
    } else {
      int i = n.indexOf(".");
      String n2 = n.substring(0,i);
      lsystems_song s = p.song_hm.get(n2);
      if (s == null) {s = new lsystems_song(p,n2);}
      return duplicate(s,n.substring(i+1));
    }
  }
  public void setModified(boolean b) {
    if (modified == b) {return;}

    lsystems_song s = this;
    while (s != null) {
      if ((modified == false) & (b == true)) {
        num_modified = num_modified + 1;
      }
      if ((modified == true) & (b == false)) {
        num_modified = num_modified - 1;
      }
      s = s.parent;
    }
    modified = b;
  }
  public void clear() {
    setModified(false);
    for (int i = 0;i < song_vec.size();i++) {
      lsystems_song s = song_vec.get(i);
      s.clear();
    }
    p_vec.clear();
    hm.clear();
    song_vec.clear();
    song_hm.clear();
  } 
  rule_notec get_last_note() {
    int s = p_vec.size();
    return p_vec.get(s-1);
  }
  public void add_song_to_hashmap(lsystems_song s) {
    s.next = song_hm.get(s.name);
    song_hm.put(s.name,s);    
  }
  public void remove_song_from_hashmap(lsystems_song s) {
    lsystems_song s2 = song_hm.get(s.name);
    if (s == s2) {
      song_hm.put(s.name,s.next);
    } else {
      while (s2.next != s) {
        s2 = s2.next;
        if (s2 == null) {return;}
      }
      s2.next = s.next;      
    }
    s.next = null;
  }
  public void remove_rule_from_hashmap(rule_notec r) {
    rule_notec r2 = hm.get(r.name);
    if (r == r2) {
      hm.put(r.name,r.next);
    } else {
      while (r2.next != r) {
        r2 = r2.next;
        if (r2 == null) {return;}
      }
      r2.next = r.next;      
      //if (r.next != null) {
      //  r.next.prev = r2;
      //}
    }
    r.next = null;
  }
  public void add_rule_to_hashmap(rule_notec r) {
    rule_notec r2 = hm.get(r.name);
    root = r;
    if (r2 == null) {
      hm.put(r.name,r);
    } else {
      while (r2.next != null) {
        r2 = r2.next;
      }
      r2.next = r;
      //r.prev = r2;
    }
  }
  public void duplicate_rule(int i) {
    rule_notec r = p_vec.get(i);
    rule_notec r2 = new rule_notec(r);
    p_vec.add(r2);
    add_rule_to_hashmap(r2);
  }
  public rule_notec startsWith(String prefix) {
    rule_notec r = null;
    Vector<rule_notec> v = new Vector<rule_notec>();
    int j = prefix.indexOf(".");
    if (j == -1) {
      for (int i = 0;i < p_vec.size();i++) {
        rule_notec n = p_vec.get(i);
        if (n.name.startsWith(prefix) == true) {
          v.add(n);
        }
      }
      if (v.size() == 0) {
        for (int i = 0;i < song_vec.size();i++) {
          lsystems_song g = song_vec.get(i);
          if (g.name.startsWith(prefix)) {
            v.add(g.startsWith(""));
          }
        }
      }
    } else {
      lsystems_song s = song_hm.get(prefix.substring(0,j));
      while (s != null) {
        rule_notec n = s.startsWith(prefix.substring(j+1));
        if (n != null) {v.add(n);}
        s = s.next;
      }
    }
    if (v.size() == 1) {r = v.get(0);}
    if (v.size() > 1) {
      r = v.get(rand.nextInt(v.size()));
    }
    return r;
  }
  public lsystems_song get_song(String name) {
    int i = name.indexOf(".");
    if (i == -1) {
      lsystems_song s = song_hm.get(name);
      if (s == null) {s = new lsystems_song(this,name);}
      return s;
    }    

    String name2 = name.substring(0,i);
    lsystems_song s = song_hm.get(name2);
    if (s == null) {s = new lsystems_song(this,name2);}
    return s.get_song(name.substring(i+1));    
  }
  public rule_notec pick_random(rule_notec r) {
    int nr = 0;
    rule_notec r2 = r;
    while (r2 != null) {
      r2 = r2.next;
      nr = nr + 1;
    }
    if (nr == 1) {return r;}
    if (nr == 0) {return null;}
    int a = rand.nextInt(nr);
    for (int i = 0;i < a;i++) {
      r = r.next;
    }
    return r;
  }
  public rule_notec get_rule(String name) {
    int i = name.indexOf(".");
    if (i == -1) {return pick_random(hm.get(name));}
    lsystems_song s = song_hm.get(name.substring(0,i));
    while (s != null) {
      rule_notec n = s.get_rule(name.substring(i+1));
      if (n != null) {return n;}
      s = s.next;
    }
    return null;
  }

  public void add_rule(String name,rule_notec r) {
    int i = name.indexOf(".");
    if (i == -1) {
      if (name.length() == 0) {return;}
      //rule_notec r = new rule_notec(r2);
      r.parent = this;
      r.name = name;
      p_vec.add(r);
      add_rule_to_hashmap(r);
    } else {
      String name2 = name.substring(0,i);
      lsystems_song s = song_hm.get(name2);
      if (s == null) {s = new lsystems_song(this,name2);}
      s.add_rule(name.substring(i+1),r);
    }
  }
  public void add_rule(String name) {
    int i = name.indexOf(".");
    if (i == -1) {
      if (name.length() == 0) {return;}
      rule_notec r = new rule_notec(this);
      r.name = name;
      long n = octave*8;
      if (p_vec.size() == 0) {
        n = rand.nextInt(octave);
      } else {      
        n = p_vec.get(p_vec.size()-1).get_note();
      }
      //n = (n+generator) % octave;
      //if (n < 0) {n = n + octave;}
      r.set_note((n+generator) % octave);
      p_vec.add(r);
      add_rule_to_hashmap(r);
      int nr = p_vec.size();
      for (int j = 0;j < max_children;j++) {
        int c = rand.nextInt(nr);
        r.child[j] = p_vec.get(c);
        r.ratio[j] = 1;
      }
      //int c1 = rand.nextInt(nr);
      //r.child[1] = p_vec.get(c1);
      //int c2 = rand.nextInt(nr);
      //r.child[2] = p_vec.get(c2);
    } else {
      String name2 = name.substring(0,i);
      lsystems_song s = song_hm.get(name2);
      if (s == null) {s = new lsystems_song(this,name2);}
      s.add_rule(name.substring(i+1));
    }
  }
  public rule_notec get_note(long note) {
    int s = p_vec.size();
    for (int i = 0;i < s;i++) {
      rule_notec r = p_vec.get(i);
      if (Math.floorMod(r.get_note(),octave) == Math.floorMod(note,octave)) {
        return r;
      }
    }
    return null;
  }
  void transpose(int t) {
    for (int i = 0;i < p_vec.size();i++) {
      rule_notec r = p_vec.get(i);
      r.set_note(r.get_note()+t);  
    }
  }
  void randomize_children(int i) {
      int nr = p_vec.size();
      rule_notec r = p_vec.get(i);
      for (int j = 0;j < max_children;j++) {
        int c = rand.nextInt(nr);
        r.child[j] = p_vec.get(c);
      }
      //int c1 = rand.nextInt(nr);
      //r.child[1] = p_vec.get(c1);
      //int c2 = rand.nextInt(nr);
      //r.child[2] = p_vec.get(c2);
  }
  public void create_song(String rule_names) {
    int mc = max_children;
    clear();
    int g = generator;
    int n = rand.nextInt(octave);
    String ss[] = rule_names.split(",");
    int nr = ss.length;
    for (int i = 0;i < nr;i++) {
      add_rule(ss[i]);
    }
    //int nr2 = p_vec.size();
    for (int i = 0;i < nr;i++) {
      rule_notec r = p_vec.get(i);
      r.set_note(n);
      n = (n + g) % octave;
      for (int j = 0;j < mc;j++) {
        r.child[j] = p_vec.get(((i*mc)+j)%nr);
        r.ratio[j] = 1;
      }
      //r.child[1] = p_vec.get((i+i+1)%nr);
    }
    root = p_vec.get(0);

  }
  public void create_random_song(String rule_names) {
    int mc = max_children;
    clear();
    int g = generator;
    int n = rand.nextInt(octave);
    //int k = rand.nextInt(tritave);
    String ss[] = rule_names.split(",");
    int nr = ss.length;
    for (int i = 0;i < nr;i++) {
      add_rule(ss[i]);
    }
    int nr2 = p_vec.size();
    for (int i = nr2-nr;i < nr;i++) {
      rule_notec r = p_vec.get(i);
      r.set_note(n);
      n = (n + g) % octave;
      for (int j = 0;j < mc;j++) {
        int ch = rand.nextInt(nr2);
        r.child[j] = get_rule(p_vec.get(ch).name);
      }
      //int c1 = rand.nextInt(nr2);
      //r.child[1] = get_rule(p_vec.get(c1).name);
      //int c2 = rand.nextInt(nr2);
      //r.child[2] = get_rule(p_vec.get(c2).name);
    }
    root = p_vec.get(0);
  }
  public void save(PrintWriter p) {
      setModified(false);
      p.println("base," + base);
      p.println("generator," + Integer.toString(generator,base));
      p.println("octave," + Integer.toString(octave,base));
      p.println("root," + root.name);
      p.println("max_children," + max_children);
      for (int i = 0;i < song_vec.size();i++) {
        lsystems_song s = song_vec.get(i);
        p.println("group," + s.name);
        s.save(p);
        p.println("group_end");
      }
      for (int i = 0;i < p_vec.size();i++) {
        rule_notec r = p_vec.get(i);
          
        String s = Long.toString(r.get_note(),base);

        String ch_names = ""; 
        for (int j = 0;j < max_children;j++) {
          if (r.child[j] != null) {ch_names = ch_names + r.child[j].get_name(this);}
          ch_names = ch_names + ",";
        }
        //String name2 = "";
        //if (r.child[2-1] != null) {name2 = r.child[2-1].get_name(this);}
        //String name3 = "";
        //if (r.child[3-1] != null) {name3 = r.child[3-1].get_name(this);}
        //long k0 = r.key[0];long k1 = r.key[1];long k2 = r.key[2];+ "," + name2 + "," + name3 + ","
        String ratio = r.get_ratio_as_string();
        p.println("r," + r.name + "," + ch_names + s + "," + ratio);
      }
  }
  public void load(BufferedReader r) {
    //p_vec = new Vector<rule_notec>();
    setModified(false);
    Vector<String> ch = new Vector<String>();
    //Vector<String> ch1 = new Vector<String>();
    //Vector<String> ch2 = new Vector<String>();
    //Vector<String> ch3 = new Vector<String>();
    String root_name = null;
    //hm = new HashMap<String,rule_notec>();
    //tkm = 0;
    String line;
    int mc = 3;
    max_children = 3;
    try {
      line = r.readLine();
      while (line != null) {
        String ss[] = line.split(",");
        for (int i = 0;i < ss.length;i++) {
          ss[i] = ss[i].trim();
        }
        if (ss[0].equals("group_end")) {break;}
        if (ss[0].equals("group")) {
          lsystems_song song = new lsystems_song(this,ss[1]);
          song.load(r);
        }
        if (ss[0].equals("base")) {
           base = Integer.parseInt(ss[1]);
        }
        if (ss[0].equals("octave")) {
           //interval23 = 2.0;
           octave = Integer.parseInt(ss[1],base);
        }
        if (ss[0].equals("generator")) {
           generator = Integer.parseInt(ss[1],base);
        }
        if (ss[0].equals("root")) {
          root_name = ss[1];
        }
        if (ss[0].equals("max_children")) {
          max_children = Integer.parseInt(ss[1]);
          mc = max_children;
        }
        if ((ss.length > (mc+3)) & (ss[0].equals("r"))) {
          for (int i = 0;i < mc;i++) {
            ch.add(ss[i+2]);
          }
          //ch1.add(ss[2]);
          //ch2.add(ss[3]);
          //ch3.add(ss[4]);
          rule_notec n = new rule_notec(this);
          n.name = ss[1];
          add_rule_to_hashmap(n);
          p_vec.add(n);
          long m = 0;
          try {
              m = Long.parseLong(ss[mc+2],base);
          } catch (NumberFormatException e) {
            System.out.println("error: " + ss[mc+2] + " is invalid");
          }
          n.set_note(m);
          n.parse_ratio(ss[mc+3]);
        }
        line = r.readLine();
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
    for (int i = 0;i < p_vec.size();i++) {
      rule_notec n = p_vec.get(i);
      for (int j = 0;j < mc;j++) { 
        n.child[j] = get_rule(ch.get((i*mc)+j));
      }
      //n.child[1-1] = get_rule(ch1.get(i));
      //n.child[2-1] = get_rule(ch2.get(i));
      //n.child[3-1] = get_rule(ch3.get(i));
    }
    if (root_name != null) {
      root = get_rule(root_name);
    }
  }
}

