import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;   
import javax.swing.table.*;
import javax.swing.filechooser.*;

import java.text.*;
import java.awt.*;
import java.awt.event.*;                       
import java.util.prefs.Preferences;

class lsystems_group_list_model extends AbstractListModel {
  lsystems_song song;
  lsystems_group_list_model(lsystems_song s) {
    this.song = s;
  }
  public Object getElementAt(int index) {
    return song.song_vec.get(index).name;
  }
  public int getSize() {
    return song.song_vec.size();
  }
}
class lsystems_column_modelc extends DefaultTableColumnModel {
  static int max_columns = 7;
  private int num_visible_columns = max_columns;
  public int column_table[];
  TableColumn t[];
  lsystems_column_modelc() {
    super();
    t = new TableColumn[max_columns];
    column_table = new int[max_columns];

    Preferences prefs = lsystems_app.prefs;
    long bits = prefs.getLong("visible_column_bits",-1);

    int fc = 0;//visible_columns_dialog.first_column;    
    int j = 0;    
    for (int i = 0;i < max_columns;i++) {
      int size = 100;
      //if (i == 0) {size = 300;}
      t[i] = new TableColumn(i,size);
      String s = getColumnName(i);
      t[i].setHeaderValue(s);
      boolean b = true;
      if (i >= fc) {
        if (((bits >> (i-fc)) & 1) == 0) {b = false;}
      }
      if (b) {     
        addColumn(t[i]);
        column_table[j] = i;
        j = j + 1;
      }
    }
    num_visible_columns = j;
  }
  int get_num_visible_columns() {
    return num_visible_columns;
  }
  void set_num_visible_columns(int c) {
    for (int i = 0;i < max_columns;i++) {
      removeColumn(t[i]);
    }
    long bits = 0;
    int fc = 0;//visible_columns_dialog.first_column;
    for (int i = 0;i < c;i++) {
      if (column_table[i] >= fc) {
        bits = bits | (1 << (column_table[i] - fc)); 
      }
      addColumn(t[column_table[i]]);
    }
    lsystems_app.prefs.putLong("visible_column_bits",bits);
    
    num_visible_columns = c;
  }
  public TableColumn getColumn(int columnIndex) {
    return t[column_table[columnIndex]];    
  }
  public int getColumnCount() {
    return num_visible_columns;
  }
  public boolean getResizable() {
    return true;
  }
  static public String getColumnName(int column) {
    return lsystems_table_model.col_name[column];
  }
}
class lsystems_table_model extends AbstractTableModel {
 static String col_name[] = {"name","note","child 1","child 2","child 3","child 4","ratio"};
  lsystems_song song;
  lsystems_table_model(lsystems_song s) {
    this.song = s;
  }
  public String getColumnName(int column) {
    return col_name[column];
  }
  public int getColumnCount() { 
    return lsystems_column_modelc.max_columns;
  }
  public int getRowCount() { 
    return song.p_vec.size();
  }
  boolean is_plus(char ch) {
    if (ch == '+') {return true;}
    if (ch == '=') {return true;}
    if (ch == '*') {return true;}
    return false;
  }
  boolean is_minus(char ch) {
    if (ch == '-') {return true;}
    if (ch == '_') {return true;}
    if (ch == '/') {return true;}
    if (ch == '\\') {return true;}
    return false;
  }
  long eval_note_str(String str,int base) {
    long s = 0;
    long r = 0;
    int sign = 1;
    for (int i = 0;i < str.length();i++) {
      char ch = str.charAt(i);
      //int d = 0;
      if ((ch >= 48) & (ch < 58)) {
        r = (r * base) + (ch - 48);
      }
      if ((ch >= 65) & (ch < 91)) {
        r = (r * base) + (ch - 55);
      }
      if ((ch >= 97) & (ch < 123)) {
        r = (r * base) + (ch - 87);
      }
      if (is_plus(ch)) {
        s = s + (r*sign);r = 0;
      }
      if (is_minus(ch)) {
        s = s + (r*sign);r = 0;
        sign = -sign;
      }      
    }
    s = s + (r*sign);
    return s;
  }
  public void setValueAt(Object val,int row,int col) {
    String str = (String) val;
    rule_notec r = song.p_vec.get(row);
    int base = song.base;
    int octave = song.octave;
    song.setModified(true);
    if (col == 0) {
      String ss[] = str.split(",");
      boolean first = true;
      for (int i = 0;i < ss.length;i++) {
        String name = ss[i].trim();
        if (name.length() > 0) {
          if (first) {
            song.remove_rule_from_hashmap(r);
            if (name.indexOf(".") == -1) {
              r.name = name;
              song.add_rule_to_hashmap(r);
            } else {
              song.p_vec.remove(r);
              song.add_rule(name,r);
            }
          } else {
            song.add_rule(name,new rule_notec(r));           
          }
          first = false;
        }
      }
    }
    if (col == 1) {r.set_note(eval_note_str(str,base));}
    if (col == 2) {r.set_child(0,str);}
    if (col == 3) {r.set_child(1,str);}
    if (col == 4) {r.set_child(2,str);}
    if (col == 5) {r.set_child(3,str);}
    if (col == 6) {r.parse_ratio(str);}
  }
  public Object getValueAt(int row, int col) { 
    rule_notec r = song.p_vec.get(row);
    int base = song.base;
    if (col == 0) {return r.name;}
    if (col == 1) {return Long.toString(r.get_note(),base);}
    if (col == 2) {return r.get_child_name(0);}
    if (col == 3) {return r.get_child_name(1);}
    if (col == 4) {return r.get_child_name(2);}
    if (col == 5) {return r.get_child_name(3);}
    if (col == 6) {return r.get_ratio_as_string();}
    return ""; 
  }
  public boolean isCellEditable(int rowIndex,int columnIndex) {
    return true;
  }

}
public class lsystems_table_window extends JFrame implements
ActionListener,MouseListener,WindowListener,KeyListener {
  JMenuBar main_menu_bar;
  JScrollPane table_scroller;
  JScrollPane list_scroller;
  JTable table;
  Preferences prefs;
  JList list;
  lsystems_song song;
  lsystems_column_modelc ls_column_model;
  oscillator_editorc oscillator_editor;
  lsystems_table_window(String Title,lsystems_song s) {
    super(Title);
    this.song = s;

    prefs = lsystems_app.prefs;
    setBounds(20,20,200,200);
    main_menu_bar = setup_menu();
    setJMenuBar(main_menu_bar);

    ls_column_model = new lsystems_column_modelc();
    table = new JTable(
         new lsystems_table_model(song),
         ls_column_model
    );
    table.addMouseListener(this);
    table.addKeyListener(this);
    list = new JList(new lsystems_group_list_model(song));
    list.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
    list.setLayoutOrientation(JList.HORIZONTAL_WRAP);
    list.setVisibleRowCount(-1);
    list_scroller = new JScrollPane(list);
    list.addMouseListener(this);
    list.addKeyListener(this);
    
    table_scroller = new JScrollPane(table);
    this.getContentPane().setLayout(new BorderLayout());
    JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
    splitPane.setTopComponent(list_scroller);
    splitPane.setBottomComponent(table_scroller);
    this.getContentPane().add(splitPane);

    if (s.parent == null) {
      setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
      this.addWindowListener(this);

    } else {
      setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    }
    this.pack();
  }
  void do_nothing_on_close() {
    setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
  }
  public void windowActivated(WindowEvent e){}
  public void windowClosed(WindowEvent e){
  }
  public void windowClosing(WindowEvent e){
    exit();
  }
  public void windowDeactivated(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowOpened(WindowEvent e){}

  boolean save_song_prompt() {

    if (song.num_modified == 0) {return true;}
    int op = JOptionPane.showConfirmDialog(this,
    "Do you want to save your song?","save song?",
    JOptionPane.YES_NO_CANCEL_OPTION);
    if (op == JOptionPane.YES_OPTION) {
       //save2();
    }             
    if (op == JOptionPane.NO_OPTION) {
      return true;
    }             
    if (song.num_modified == 0) {return true;}
    return false;
  }  
  void exit() {
    //lsystems_app.save_window_positions();
    if (save_song_prompt()) {System.exit(0);}
  }
  JMenuItem createCheckBoxMenuItem(String text,JMenu menu,String action) {
    JMenuItem mi = new JCheckBoxMenuItem(text);
    menu.add(mi);
    mi.setActionCommand(action);    
    mi.addActionListener(this);
    return mi;
  }

  JMenuItem createMenuItem(String text,JMenu menu,String action) {
    JMenuItem mi = new JMenuItem(text);
    menu.add(mi);
    mi.setActionCommand(action);    
    mi.addActionListener(this);
    return mi;
  }
  static String replace_with_underscore(String s) {
    s = s.replaceAll(" ", "_");
    s = s.replaceAll("\\.", "_");
    s = s.replaceAll(",", "_");
    return s;
  }

  long string_to_seed(String str) {
    long seed = 0;
    for (int i = 0;i < str.length();i++) {
      int ch = str.charAt(i);
      seed = (seed * 10) + ch - 48;
    }
    return seed;
  }
  void update_selected_rows() {
      music_playerc mp = lsystems_app.mp;
      //mp.index = table.getSelectedRow();
      //System.out.println(table.getSelectedRow());
      //mp.selected_rows = table.getSelectedRows();
      //mp.is_playing = (mp.song == song);
      song.root = song.p_vec.get(table.getSelectedRow());
      //song.root = song.p_vec.get(song.p_vec.size()-1);
      mp.song = song;
  }
  public void keyPressed(KeyEvent e){
    int a = e.getKeyCode();
    char ch = e.getKeyChar();  
    String s = e.getKeyText(a);
    if (e.getComponent() == list) {
      ch = Character.toLowerCase(ch);
      if (ch == 't') {
        transpose_song();
      }
    }
    if (e.getComponent() == table) {
      if (e.isControlDown()) {
        //System.out.println("ch: " + ch);
        if (a == KeyEvent.VK_T) {
          transpose_notes();
        }
      }      
    }
  }
  public void keyReleased(KeyEvent e){
    if (e.getComponent() == table) {
      update_selected_rows();
    }
  }
  public void keyTyped(KeyEvent e){}
  //public void keyTyped(KeyEvent e){}
  public void mouseClicked(MouseEvent e){
    if (e.getComponent() == list) {
      if (e.getClickCount() == 2) {
        //System.out.println("double clicked");
        int i = list.getSelectedIndex();
        if (i != -1) {
          lsystems_song s = song.song_vec.get(i);
          lsystems_table_window lst_win = new lsystems_table_window(s.name, s);
          lst_win.setVisible(true);
        }
      }
    }
  }
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}
  public void mousePressed(MouseEvent e){}
  public void mouseReleased(MouseEvent e){
    if (e.getComponent() == table) {
      update_selected_rows();
    }
  }
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    int base = song.base;
    int octave = song.octave;
    Preferences prefs = lsystems_app.prefs;
    if (action.equals("menu_new")) {
      if (save_song_prompt()) {
        new_song_dialog d = new new_song_dialog(this,song);
        d.show();
        lsystems_app.mp.pos = 1.0;
      }
    }
    if (action.equals("menu_open_multiple")) {open3();}
    if (action.equals("menu_open")) {
      if (save_song_prompt()) {
        open2();
        lsystems_app.mp.pos = 1.0;
      }
    }
    if (action.equals("menu_save")) {save2();}
    if (action.equals("menu_random_children")) {
      int rows[] = table.getSelectedRows();
      int l = rows.length;
      for (int i = 0;i < l;i++) {
        song.randomize_children(rows[i]);
      }
    }
    if (action.equals("menu_duplicate_rules")) {
      int rows[] = table.getSelectedRows();
      int l = rows.length;
      for (int i = 0;i < l;i++) {
        song.duplicate_rule(rows[i]);
      }
    }
    if (action.equals("menu_add_rule")) {
      rule_notec first_note = null;
      int j = song.p_vec.size();
      String d = "a";
      if (j > 0) {
        first_note = song.p_vec.get(0);
        d = first_note.name + j;
      }
      String s = (String)JOptionPane.showInputDialog(
                    this,
                    "enter rule name",
                    "enter rule name",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    d); 
      if (s != null) {
        String ss[] = s.split(",");
        for (int i = 0;i < ss.length;i++) {
          String r = ss[i].trim();
          if (r != null) {
            if (r.length() > 0) {
              song.add_rule(r);
            }
          }
        }
      }        
    }
    if (action.equals("menu_rename_group")) {
      int i = list.getSelectedIndex();
      lsystems_song g = song.song_vec.get(i);
      String str = (String)JOptionPane.showInputDialog(
                    this,
                    "enter new group name",
                    "rename group",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    g.name); 
      String ss[] = str.split(",");
      boolean first = true;
      for (int j = 0;j < ss.length;j++) {
        String name = ss[j].trim();
        if (name.length() > 0) {
          if (first) {
            int li = name.lastIndexOf(".");
            if (li == -1) {
              //g.rename(name);
              song.remove_song_from_hashmap(g);
              g.name = name;
              song.add_song_to_hashmap(g);
            } else {
              //if ((song2 != null) & (song != song2)) {
                song.song_vec.remove(i);
                song.remove_song_from_hashmap(g);
                g.name = name.substring(li+1);
                lsystems_song song2 = song.get_song(name.substring(0,li));
                song2.add_song_to_hashmap(g);
                song2.song_vec.add(g);
              //}
            }
          } else {
            g.duplicate(song,name);
            //song.add_rule(name + ".");
          }
          first = false;
        }
      }
    }
    if (action.equals("menu_duplicate_group")) {
      int j = list.getSelectedIndex();
      lsystems_song sg = song.song_vec.get(j);
      String s = (String)JOptionPane.showInputDialog(
                    this,
                    "enter group name",
                    "enter group name",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    "g"); 
      if (s != null) {
        String ss[] = s.split(",");
        for (int i = 0;i < ss.length;i++) {
          String g = ss[i].trim();
          if (g != null) {
            if (g.length() > 0) {
              //new lsystems_song(song,g);
              sg.duplicate(song,g);
            }
          }
        }
      }                    
    }
    if (action.equals("menu_add_group")) {
      String s = (String)JOptionPane.showInputDialog(
                    this,
                    "enter group name",
                    "enter group name",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    "g"); 
      if (s != null) {
        String ss[] = s.split(",");
        for (int i = 0;i < ss.length;i++) {
          String g = ss[i].trim();
          if (g != null) {
            if (g.length() > 0) {
              //new lsystems_song(song,g);
              song.add_rule(g + ".");
            }
          }
        }
      }              
    }
    if (action.equals("visible_columns")) {
      visible_columns_dialog d = new visible_columns_dialog(this,"visible columns",ls_column_model);
      d.show();
      if (d.OK_Clicked()) {
        int max_columns = lsystems_column_modelc.max_columns;

        int j = visible_columns_dialog.first_column;
        for (int i = j;i < max_columns;i++) {
          if (d.is_visible(i)) {
            ls_column_model.column_table[j] = i;
            j = j + 1;
          }
        }
        ls_column_model.set_num_visible_columns(j);
        //table.resizeAndRepaint();
        table.updateUI();
      }
    }
    if (action.equals("reduce_to_one_octave")) {
      reduce_to_one_octave();
    }
    if (action.equals("menu_shuffle_children")) {
      shuffle_children();
    }
    if (action.equals("menu_rotate_notes_up")) {
      rotate_notes_up();
    }
    if (action.equals("menu_rotate_notes_down")) {
      rotate_notes_down();
    }
    if (action.equals("menu_transpose_notes")) {
      transpose_notes();
    }
    if (action.equals("menu_transpose_song")) {
      transpose_song();
    }
    if (action.equals("menu_shuffle_notes")) {
      shuffle_notes();
    }
    if (action.equals("menu_show_harmonics")) {
      harmonic_table_window ht_win = new harmonic_table_window(song.name, song);
      ht_win.setVisible(true);
    }
    if (action.equals("menu_show_settings")) {
      lsystems_app.ssw.setVisible(true);
    }

    if (action.equals("menu_equalizer")) {
      lsystems_app.equalizer_window.setVisible(true);
    }
    if (action.equals("menu_iso_keyboard")) {
      iso_keyboard_window iso_key_win = new iso_keyboard_window(song,table);
      iso_key_win.setVisible(true);
    }
    if (action.equals("instrument_oscillator_editor")) {
      if (oscillator_editor == null) {
        oscillator_editor = new oscillator_editorc();
      }
      oscillator_editor.setVisible(true);
    }
    if (action.equals("instrument_options")) {

    }
    if (action.equals("menu_exit")) {
      if (song.parent == null) {
        exit();
      } else {
        this.dispose();
      }
    }

  }
  void transpose_song() {
      int base = song.base;
      int octave = song.octave;
      int t = song.rand.nextInt((octave * 2)+1) - octave;
      String str = (String)JOptionPane.showInputDialog(
                    this,
                    "transpose notes",
                    "enter interval",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    Integer.toString(t,base));
      if (str != null) {
        int i = list.getSelectedIndex();
        if (i == -1) {return;}
        lsystems_song s = song.song_vec.get(i);
        try {
          t = Integer.parseInt(str,base);
          s.transpose(t);
        } catch (NumberFormatException e) {
          JOptionPane.showMessageDialog(this,
            "interval " + str + " is invalid","error",
          JOptionPane.ERROR_MESSAGE);          
        }
      }
  }
  void rotate_notes_up() {
    int rows[] = table.getSelectedRows();
    int l = rows.length;
    rule_notec r = song.p_vec.get(rows[0]);
    long m = r.get_note();
    for (int j = l-1;j >= 0;j--) {
      r = song.p_vec.get(rows[j]);
      long n = r.get_note();
      r.set_note(m);
      m = n;
    }
  }
  void rotate_notes_down() {
    int rows[] = table.getSelectedRows();
    int l = rows.length;
    rule_notec r = song.p_vec.get(rows[l-1]);
    long m = r.get_note();
    for (int j = 0;j < l;j++) {
      r = song.p_vec.get(rows[j]);
      long n = r.get_note();
      r.set_note(m);
      m = n;
    }
  }
  void rotate_notes() {
      int base = song.base;
      int octave = song.octave;
      int t = song.rand.nextInt(song.p_vec.size());
      String s = (String)JOptionPane.showInputDialog(
                    this,
                    "rotate notes",
                    "enter offset",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    Integer.toString(t));
      if (s != null) {
        int i = 0;
        try {
          i = Integer.parseInt(s);
        } catch (NumberFormatException e) {
          JOptionPane.showMessageDialog(this,
            "interval " + s + " is invalid","error",
          JOptionPane.ERROR_MESSAGE);   
          return;       
        }
        int rows[] = table.getSelectedRows();
        int l = rows.length;
        for (int j = 0;j < l;j++) {
          rule_notec r = song.p_vec.get(rows[j]);
          r.set_note(r.get_note()+i);            
        }
      }

  }
  void reduce_to_one_octave() {
      int octave = song.octave;
      int rows[] = table.getSelectedRows();
      int l = rows.length;
      for (int j = 0;j < l;j++) {
          rule_notec r = song.p_vec.get(rows[j]);
          long n = r.get_note() % octave;
          if (n < 0) {n = n + octave;}
          r.set_note(n);                    
      }
  }
  void transpose_notes() {
      int base = song.base;
      int octave = song.octave;
      int t = song.rand.nextInt((octave * 2)+1) - octave;
      String s = (String)JOptionPane.showInputDialog(
                    this,
                    "transpose notes",
                    "enter interval",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    Integer.toString(t,base));
                    //prefs.get("transpose_interval","0"));
      if (s != null) {
        int i = 0;
        try {
          i = Integer.parseInt(s,base);
        } catch (NumberFormatException e) {
          JOptionPane.showMessageDialog(this,
            "interval " + s + " is invalid","error",
          JOptionPane.ERROR_MESSAGE);   
          return;       
        }
        //prefs.put("transpose_interval",s);
        int rows[] = table.getSelectedRows();
        int l = rows.length;
        for (int j = 0;j < l;j++) {
          rule_notec r = song.p_vec.get(rows[j]);
          r.set_note(r.get_note()+i);            
        }
      }
  }
  void shuffle_children() {
    int rows[] = table.getSelectedRows();
    int l = rows.length;
    int mc = song.max_children;
    Vector<rule_notec> v = new Vector<rule_notec>();
    for (int j = 0;j < l;j++) {
      rule_notec r = song.p_vec.get(rows[j]);
      for (int c = 0;c < mc;c++) {
        if (r.ratio[c] != 0) {v.add(r.child[c]);}             
      }
    }
    for (int j = 1;j < v.size();j++) {
      int i = song.rand.nextInt(j+1);
      rule_notec tmp = v.get(i);
      v.set(i,v.get(j));
      v.set(j,tmp);
    }
    int i = 0;
    for (int j = 0;j < l;j++) {
      rule_notec r = song.p_vec.get(rows[j]);
      for (int c = 0;c < mc;c++) {
        if (r.ratio[c] != 0) {
          r.child[c] = v.get(i);
          i++;
        }
      }
    }
  }
  void shuffle_notes() {
    int rows[] = table.getSelectedRows();
    int l = rows.length;
    for (int j = 1;j < l;j++) {
      int i = song.rand.nextInt(j+1);
      rule_notec r1 = song.p_vec.get(rows[i]);
      rule_notec r2 = song.p_vec.get(rows[j]);
      long tmp = r1.get_note();
      r1.set_note(r2.get_note());
      r2.set_note(tmp);
    }
  }

  JMenuBar setup_menu() {
    JMenuBar mb = new JMenuBar();
    JMenu file_menu = new JMenu("file");
    createMenuItem("new",file_menu,"menu_new");
    createMenuItem("open",file_menu,"menu_open");
    createMenuItem("open multiple",file_menu,"menu_open_multiple");
    createMenuItem("save",file_menu,"menu_save");
    //createMenuItem("export to wave",file_menu,"menu_export_wave");
    createMenuItem("exit",file_menu,"menu_exit");
    mb.add(file_menu);

    JMenu rule_menu = new JMenu("rule");
    createMenuItem("add",rule_menu,"menu_add_rule");
    createMenuItem("duplicate",rule_menu,"menu_duplicate_rules");
    createMenuItem("random children",rule_menu,"menu_random_children");
    createMenuItem("shuffle children",rule_menu,"menu_shuffle_children");
    createMenuItem("transpose notes",rule_menu,"menu_transpose_notes");
    createMenuItem("reduce to one octave",rule_menu,"reduce_to_one_octave");
    createMenuItem("rotate notes up",rule_menu,"menu_rotate_notes_up");
    createMenuItem("rotate notes down",rule_menu,"menu_rotate_notes_down");
    createMenuItem("shuffle notes",rule_menu,"menu_shuffle_notes");
    mb.add(rule_menu);


    JMenu group_menu = new JMenu("group");
    createMenuItem("add",group_menu,"menu_add_group");
    createMenuItem("rename",group_menu,"menu_rename_group");
    createMenuItem("duplicate",group_menu,"menu_duplicate_group");
    createMenuItem("transpose",group_menu,"menu_transpose_song");
    mb.add(group_menu);

    JMenu view_menu = new JMenu("view");
    createMenuItem("visible columns",view_menu,"visible_columns");
    createMenuItem("harmonic table",view_menu,"menu_show_harmonics");
    createMenuItem("settings",view_menu,"menu_show_settings");
    createMenuItem("equalizer",view_menu,"menu_equalizer");
    createMenuItem("iso keyboard",view_menu,"menu_iso_keyboard");
    createMenuItem("oscillator editor",view_menu,"instrument_oscillator_editor");

    mb.add(view_menu);

    //JMenu instrument_menu = new JMenu("instrument");
    //createMenuItem("options",instrument_menu,"instrument_options");
    //createMenuItem("harmonic editor",instrument_menu,"instrument_harmonic_editor");
    //mb.add(instrument_menu);

    return mb;

  }
  void open3() {
      try{
        //FileDialog f = new FileDialog(this,"open songs",FileDialog.LOAD);
        JFileChooser f = new JFileChooser();
        Preferences prefs = lsystems_app.prefs;
        String dirname = prefs.get("song_directory",null);

        if (dirname != null) {f.setCurrentDirectory(new File(dirname));}
        f.setMultiSelectionEnabled(true);
        f.showOpenDialog(this);
        File fl[] = f.getSelectedFiles();
        for (int i = 0;i < fl.length;i++) {
          BufferedReader r = new BufferedReader(new FileReader(fl[i]));
          String first_line = r.readLine();
          first_line.trim();
          if (first_line.equals("franks_java_lsystems_song_generator2")) {
            String name = replace_with_underscore(fl[i].getName());
            lsystems_song s = new lsystems_song(song,name);
            s.load(r);
          } else {
            JOptionPane.showMessageDialog(
             this, "can not open " + fl[i].getName(),
             "error",JOptionPane.ERROR_MESSAGE);
          }
          r.close();
        }
        if (fl.length > 0) {
          dirname = fl[0].getParent() + File.separator;
          prefs.put("song_directory",dirname);
          song.build_album(fl.length);
        }
      } catch (Exception err) {
        System.out.println("menuopen error");
        System.out.println(err.getMessage());
        err.printStackTrace();
      }

  }
  void open2() {
      try{
        FileDialog f = new FileDialog(this,"open song",FileDialog.LOAD);
        //System.out.println(main_panelc.dirname);
        Preferences prefs = lsystems_app.prefs;

        String dirname = prefs.get("song_directory",null);
        if (dirname != null) {f.setDirectory(dirname);}
        //f.setDirectory("a3928798237"); 
        f.show();
        if (f.getFile() != null) {
          String filename = f.getDirectory() + f.getFile();
          music_playerc mp = lsystems_app.mp;
          BufferedReader r = new BufferedReader(new FileReader(filename));
          String first_line = r.readLine();
          first_line.trim();
          if (first_line.equals("franks_java_lsystems_song_generator2")) {
            song.clear();
            song.load(r);
          } else {
            JOptionPane.showMessageDialog(
             this, "can not open " + f.getFile(),
             "error",JOptionPane.ERROR_MESSAGE);
          }
          r.close();
          mp.song = song;
          //table.setSelectedRow(song.root.get_index());
          //mp.root_note = null;
          //key_tempo_mi.setSelected(song.tkm != 1);
          //mp.root_note = song.p_vec.get(0);
          //mp.is_playing = false;
          //int ft = get_file_type(filename);
          //if (ft == 1) {
          //  DataInputStream infile = new DataInputStream(new BufferedInputStream(
          //  new  GZIPInputStream(new FileInputStream(filename))));
          //  open_file(infile);
          //} else if (ft == 2) {
            //new song_browserc(filename);
          //} else {
          //  JOptionPane.showMessageDialog(main_frame,
          //  "error: invalid gz file","can not open file",
          //  JOptionPane.ERROR_MESSAGE);
          // 
          //}
          //main_panel.repaint();
          //main_panelc.filename = f.getFile();
          //main_panelc.dirname = f.getDirectory();
          prefs.put("song_directory",f.getDirectory());
          //mp.is_playing = false;
        }         
      } catch (Exception err) {
        System.out.println("menuopen error");
        System.out.println(err.getMessage());
        err.printStackTrace();
      }
  }
  void save2() {
      try{
        FileDialog fd = new FileDialog(this,"save song",FileDialog.SAVE);
        //main_panelc.dirname = prefs.get("song_directory",null);
        Preferences prefs = lsystems_app.prefs;

        String dirname = prefs.get("song_directory",null);
        if (dirname != null) {fd.setDirectory(dirname);}
        //f.setDirectory(main_panelc.dirname);
        //f.setFile(main_panelc.filename);
        fd.show();
        if (fd.getFile() != null) {
          String filename = fd.getDirectory() + fd.getFile();
          File f = new File(filename);
          boolean file_exists = f.exists();
          PrintWriter p = new PrintWriter(new BufferedWriter(
                      new FileWriter(f,true)));
          if (file_exists) {
            p.println("group," + System.currentTimeMillis());
            song.save(p);
            p.println("group_end");
          } else {
            p.println("franks_java_lsystems_song_generator2");
            //p.println("version,1");
            song.save(p);
          }
          p.close();
          //music_playerc.song.save(filename);

          //File f2 = new File(filename);
          //String filename2 = main_panelc.dirname;
          //filename2 = filename2 + main_panelc.filename;
          //if ((f2.exists() == false) | (filename.equals(filename2)) == true) {
          //  save_file(filename);
          //  main_panelc.filename = f.getFile();
          //  main_panelc.dirname = f.getDirectory();
          //  prefs.put("song_directory",main_panelc.dirname);
          prefs.put("song_directory",fd.getDirectory());

          //} else {
          //  JOptionPane.showMessageDialog(main_frame,new JLabel("file already exists"),"error",JOptionPane.ERROR_MESSAGE);
          //}
        }
      } catch (Exception err) {
        System.out.println("menusave error");
        System.out.println(err.getMessage());
        err.printStackTrace();
      }
  }  

}
class visible_columns_dialog extends JDialog implements ActionListener{
  JPanel button_panel;

  int num_checkboxes;
  JCheckBox checkbox[];
  boolean result;
  static int first_column = 4;
  visible_columns_dialog(Frame owner,String title,
                         lsystems_column_modelc ls_column_model) {
    super(owner,title,true);
    setBounds(20,20,200,200);
    
    int fc = first_column;
    int max_columns = lsystems_column_modelc.max_columns;
    this.getContentPane().setLayout(new GridLayout((max_columns+1)-fc,1));
    checkbox = new JCheckBox[max_columns-fc];
    for (int i = fc;i < max_columns;i++) { 
      create_checkbox(lsystems_column_modelc.getColumnName(i));
    }
    //create_checkbox("mode");
    //create_checkbox("key");
    //create_checkbox("tuning");

    int num_visible_columns = ls_column_model.get_num_visible_columns();
    for (int i = fc;i < num_visible_columns;i++) {
      int j = ls_column_model.column_table[i];
      checkbox[j-fc].setSelected(true);
    }

    button_panel = new JPanel();
    this.getContentPane().add(button_panel);    
    button_panel.setLayout(new GridLayout(1,2));    
    create_button("ok","ok");
    create_button("cancel","cancel");
  }
  boolean is_visible(int i) {
    return checkbox[i-first_column].isSelected();
  }
  void create_checkbox(String text) {
    int i = num_checkboxes;
    checkbox[i] = new JCheckBox(text);
    this.getContentPane().add(checkbox[i]);
    num_checkboxes = num_checkboxes + 1;
  }
  JButton create_button(String text,String action) {  
    JButton button = new JButton(text);
    button.setActionCommand(action);    
    button.addActionListener(this);
    button_panel.add(button);
    return button;
  }
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    //System.out.println(action);
    result = false;         
    if (action.equals("ok")) {
      result = true;
    }
    hide();
  }
  boolean OK_Clicked() {
    return result;
  }
}

