import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;   
import javax.swing.table.*;
import javax.swing.filechooser.*;

import java.text.*;
import java.awt.*;
import java.awt.event.*;                       
import java.util.prefs.Preferences;

class harmonic_table_model extends AbstractTableModel {
  String col_name[] = {"harmonic","note"};
  lsystems_song song;
  int harmonic = 1;
  harmonic_table_model(lsystems_song s) {
    this.song = s;
  }
  public String getColumnName(int column) {
    return col_name[column];
  }
  public int getColumnCount() { 
    return 2;
  }
  public int getRowCount() { 
    return 16;
  }
  public Object getValueAt(int row, int col) {
    int harmonic2 = row+1;
    if (col == 1) {
      double f = harmonic2;
      f = Math.log(f / harmonic) * song.octave;
      f = f / Math.log(2);
      long l = Math.round(f);
      return Long.toString(l,song.base);
    }
    return new Integer(harmonic2);
  }
  public boolean isCellEditable(int rowIndex,int columnIndex) {
    return false;
  }
}

public class harmonic_table_window extends JFrame implements
ActionListener,MouseListener {
  JScrollPane table_scroller;
  JTable table;
  lsystems_song song;
  harmonic_table_model hm;
  harmonic_table_window(String Title,lsystems_song s) {
    super(Title);
    this.song = s;
    setBounds(80,20,200,200);
    hm = new harmonic_table_model(song);
    table = new JTable(
      hm
    );
    table.addMouseListener(this);

    table_scroller = new JScrollPane(table);
    this.getContentPane().setLayout(new BorderLayout());
    this.getContentPane().add(table_scroller);
    this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    this.pack();
  }
  public void mouseClicked(MouseEvent e){
    int r = table.getSelectedRow();
    hm.harmonic = r+1;
    table.updateUI();
  }
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}
  public void mousePressed(MouseEvent e){}
  public void mouseReleased(MouseEvent e){}
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
  }
}

