import java.lang.*;
import java.util.*;
import java.io.*;
import javax.swing.*;   

import java.util.prefs.Preferences;

class lsystems_app implements Runnable {
  static lsystems_table_window lst_win;
  static spinner_settings_window ssw;
  static music_playerc mp;
  static Preferences prefs = Preferences.userRoot().node("lsystems_54387346");
  static equalizer_windowc equalizer_window;

  public static void main(String[] args)
    throws	Exception
  {    
    lsystems_song mp_song = new lsystems_song();
    if (args.length >= 1) {
      //music_playerc.filename = args[0];
      //music_playerc.length = Integer.parseInt(args[1]);
      try {
        BufferedReader r = new BufferedReader(new FileReader(args[0]));
        mp_song.load(r);
        r.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    } else {
      create_new_song(mp_song);
    }
    mp = new music_playerc();
    mp.song = mp_song;
    mp.start();
    javax.swing.SwingUtilities.invokeLater(new lsystems_app());
  }
  public static void create_new_song(lsystems_song song) {
      String name = prefs.get("name","f,c,g,d,a");
      int b = prefs.getInt("base",6);

      String octave = prefs.get("octave","110");

      song.base = b;
      song.max_children = prefs.getInt("max_children",3);
      try {
        song.octave = Integer.parseInt(octave,b);
      } catch (NumberFormatException e) {
        song.octave = b;
      }

      try {
        song.generator = Integer.parseInt(prefs.get("generator","200"),b);
      } catch (NumberFormatException e) {
        song.generator = 0;
      }
      song.create_random_song(name);
      //mp.song = song;
  }
  public void run() {    
    lst_win = new lsystems_table_window("frank's java lsystems song generator 2", mp.song);
    lst_win.setVisible(true);
    ssw = new spinner_settings_window("settings");
    ssw.setVisible(true);
    equalizer_window = new equalizer_windowc();
    equalizer_window.setVisible(true);
  }
}

