import java.lang.*;
import java.util.*;
import java.io.*;
import javax.sound.sampled.*;

import java.util.prefs.Preferences;

public class music_playerc extends abstract_music_playerc  {
  SourceDataLine output_line;
  int bsize = 1024;
  float buf[] = new float[bsize];
  byte abData[] = new byte[bsize*4];
  static int sample_rate = 48000;
  lsystems_song song = null;
  double pos = 0.0;
  //int index = 0;
  static String filename = null;
  //static int len_in_secs = 30;

  equalizerc equalizer = null; 
  static Preferences prefs = lsystems_app.prefs;
  static double length = prefs.getDouble("length",120.0);
  static boolean writeToStdOut = false;
 

  static int num_generations = prefs.getInt("num_generations",12);
  static int volume_db = prefs.getInt("volume",85);
  static double volume = 1.0f;
  static int key = prefs.getInt("key",0);
  static boolean run_from_main = false;
  static Vector harmonic_list = new Vector();
  //static Vector oscillator_list = new Vector();
  music_playerc() throws Exception {
    super();
    harmonic_list.add(new Harmonic(1.0f,1.0f,1.0f));//f v bw
    //harmonic_list.add(new Harmonic(2.0f,0.5f,2.0f));//f v bw
    //oscillator_list.add(new Harmonic(1.0f,1.0f,0.5f));
    Preferences osl_prefs = prefs.node("oscillator_list");
    int num_os = osl_prefs.getInt("num_oscillators",1);
    for (int i = 0;i < num_os;i++) {
      float freq  = osl_prefs.getFloat("freq"+i,1.0f);
      float vol   = osl_prefs.getFloat("vol"+i,1.0f);
      float phase = osl_prefs.getFloat("phase"+i,0.5f);
      oscillator_list.add(new Harmonic(freq,vol,phase));
    }
    ins = new sampletablec(12,5,100.0f,harmonic_list);
    if (filename != null) {
      song = new lsystems_song();      
      //try{
        BufferedReader br;
        if (filename.equals("-")) {
          br = new BufferedReader(new InputStreamReader(System.in));
        } else {
          br = new BufferedReader(new FileReader(filename));
        }
        song.load(br);
        br.close();
    }

    if (writeToStdOut) {
      writeheader();// {mp.writeheader();}
    } else {
      output_line = createline(sample_rate);
    }
  }
  static void update() {
    abstract_music_playerc.ins = new sampletablec(15,5,100.0f,harmonic_list);
  }
  public SourceDataLine createline(int sample_rate) {
    //int nc = 1;
    //if (t_Stereo) {nc = 2;}
    AudioFormat audioFormat = new AudioFormat((float) sample_rate,16,2,true,false);
    SourceDataLine	line = null;
    DataLine.Info	info = new DataLine.Info(SourceDataLine.class,audioFormat,8192/8);
    try {
      line = (SourceDataLine) AudioSystem.getLine(info);
      line.open(audioFormat);
    } catch (LineUnavailableException e) {
      e.printStackTrace();
    } catch (Exception e) {
      e.printStackTrace();
    }

    line.start();
    return line;	  
  }
  void equalizer_update_filter() {
      int nb = equalizer_windowc.num_bands2;
      //int nb = equalizer_windowc.prefs.getInt("num_bands",12);
      if (equalizer == null) {
        equalizer = new equalizerc(nb);
        int band_db[] = equalizer_windowc.get_band_db_array();
        equalizer.update_filter(band_db);
      }
      if (equalizer.num_bands != nb) {
        System.out.println("nb: " + nb);
        //System.out.println("equalizer.num_bands: " + equalizer.num_bands);
        equalizer = new equalizerc(nb);
        int band_db[] = equalizer_windowc.get_band_db_array();
        equalizer.update_filter(band_db);      
      }
      if (equalizer_windowc.eq_changed) {
        int band_db[] = equalizer_windowc.get_band_db_array();
        equalizer.update_filter(band_db);
        equalizer_windowc.eq_changed = false;
      }
  }
  public void run() {
    rule_notec root = song.root;//p_vec.get(index);
    pos = 0.0;
    int i = 0;
    double s2 = 0;
    //dpos = dpos / sample_rate;
    //dpos = dpos / length;
    while (pos < 1.0) {
      double dpos = 1.0 / (sample_rate * length);
      double s = (play_sample(root,pos,num_generations)); //0.3;
      //System.out.println(s);
      pos = pos + dpos;
      s = s / (dpos*2000000);
      buf[i] = (float) ((s-s2)*100.0*volume);
      s2 = s;
      i = i + 1;
      if (i == bsize) {
        if (equalizer_windowc.eq_enabled) {
          equalizer_update_filter();
          equalizer.filter1(buf,bsize);
        }
        for (i = 0;i < bsize;i++) {
          int ws = ((int) (clip(buf[i]) * 32700.0));
          abData[(i*4)+0] = (byte) (ws & 255);
          abData[(i*4)+1] = (byte) (ws >> 8);	
          abData[(i*4)+2] = (byte) (ws & 255);
          abData[(i*4)+3] = (byte) (ws >> 8);	
        }
        if (writeToStdOut) {
          System.out.write(abData, 0, bsize*4);
        } else {
          output_line.write(abData, 0, bsize*4);            
        } 
        i = 0;
      }
      if (run_from_main == false) {
        if (pos >= 1.0) {
          pos = 0.0;
          root = song.root;
          //root = song.p_vec.get(index);
        }
      }
    }
  }
  static int swapbytesofword(int n) {
    return (((n >> 8) & 255) | ((n & 255) << 8));
  }
  static int swapbytesofint(int n) {
    return (((n >> 24) & 255) << 0) | (((n >> 16) & 255) << 8) |
    (((n >> 8) & 255) << 16) | (((n >> 0) & 255) << 24);
  }

  void writeheader() {
    try {
      DataOutputStream wave_out = new DataOutputStream(System.out);
      boolean downsampling2 = false;
      boolean stereo = true;
      boolean bits16 = true;
      wave_out.writeBytes("RIFF");
      wave_out.writeInt(swapbytesofint(-1));
      wave_out.writeBytes("WAVE");
      wave_out.writeBytes("fmt ");
      wave_out.writeInt(swapbytesofint(16));
      wave_out.writeShort(swapbytesofword(1));
      if (stereo == true) {
        wave_out.writeShort(swapbytesofword(2));
      } else {
        wave_out.writeShort(swapbytesofword(1));
      }
      int sample_rate2 = sample_rate;
      if (downsampling2) {sample_rate2 = sample_rate2 >> 1;}

      wave_out.writeInt(swapbytesofint(sample_rate2));
      int b = 1;
      if (stereo == true) {b = b * 2;}
      if (bits16 == true) {b = b * 2;}
      
      wave_out.writeInt(swapbytesofint(sample_rate2*b));
      wave_out.writeShort(swapbytesofword(b));
      if (bits16 == true){
        wave_out.writeShort(swapbytesofword(16));
      } else {
        wave_out.writeShort(swapbytesofword(8));
      }
      wave_out.writeBytes("data");
      wave_out.writeInt(swapbytesofint(-1));
    } catch (Exception e) {
      e.printStackTrace();      
    }
  }  

  public static void main(String[] args)
    throws	Exception
  {    
    //System.out.println(args[0]);
    //System.out.println(args.length);
    boolean readLength = false;
    boolean readSampleRate = false;
    for (int i = 0;i < args.length;i++) {
    //if (args.length >= 1) {
      //if (args.length >= 2) {
      if (args[i].equals("-c")) {
        writeToStdOut = true;
        continue;
      }
      if (args[i].equals("-l")) {
        readLength = true;
        continue;
      }
      if (args[i].equals("-r")) {
        readSampleRate = true;
        continue;
      }
      if (readSampleRate == true) {
        try {
          int r = Integer.parseInt(args[i]);
          sample_rate = r;
        } catch (NumberFormatException e) {
           System.err.println("invalid rate " + args[i]);
        }
        readSampleRate = false;
        continue;
      }
      if (readLength == true) {
        try {
          double l = Double.parseDouble(args[i]);
          length = l;
        } catch (NumberFormatException e) {
           System.err.println("invalid length " + args[i]);
        }
        readLength = false;
        continue;
      }
      //}
      filename = args[i];
    }
    music_playerc mp = new music_playerc();
    mp.run_from_main = true;
    mp.start();
  }
}

