import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;   
import javax.swing.table.*;
      
import java.text.*;
import java.awt.*;
import java.awt.event.*;                       
import java.util.prefs.Preferences;

public class new_song_dialog extends JDialog implements ActionListener {
  JTextField name_field;
  JSpinner base_spinner;
  JTextField octave_field;
  JTextField generator_field;
  JSpinner max_children_spinner;
  JButton okButton;
  JButton cancelButton;
  Preferences prefs;
  lsystems_song song;

  new_song_dialog(Frame owner,lsystems_song s) {
    super(owner,"new song",false);
    this.song = s;
    prefs = lsystems_app.prefs;
    this.getContentPane().setLayout(new GridLayout(6,2));
    name_field = create_text_field("rule names: ",prefs.get("name","f,c,g,d,a"));
    int b = prefs.getInt("base",6);
    base_spinner = create_spinner("base: ",new SpinnerNumberModel(b,2,36,1));
    int mc = prefs.getInt("max_children",3);
    max_children_spinner = create_spinner("max children: ",new SpinnerNumberModel(mc,2,4,1));
    generator_field = create_text_field("generator: ",prefs.get("generator","110"));

    octave_field = create_text_field("octave: ",prefs.get("octave","200"));
    this.getContentPane().add(octave_field);
    this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

    okButton = create_button("ok","ok");
    cancelButton = create_button("cancel","cancel");
    this.pack();

  }
  JTextField create_text_field(String label,String text) {  
    this.getContentPane().add(new JLabel(label));
    JTextField t_field = new JTextField(text);
    this.getContentPane().add(t_field);
    return t_field;
  }
  JButton create_button(String text,String action) {  
    JButton button = new JButton(text);
    button.setActionCommand(action);    
    button.addActionListener(this);
    this.getContentPane().add(button);
    return button;
  }
  JSpinner create_spinner(String text,SpinnerNumberModel m){
    JLabel label = new JLabel(text);
    this.getContentPane().add(label);
    JSpinner s = new JSpinner(m);
    this.getContentPane().add(s);
    return s;
  }
  public void actionPerformed(ActionEvent ev) {        
    String action = ev.getActionCommand();
    if (action.equals("ok")) {
      music_playerc mp = lsystems_app.mp;
      String s = name_field.getText();
      Number n = (Number) base_spinner.getValue();
      int b = n.intValue();
      String octave_str = octave_field.getText();
      int octave = 0;
      try {
        octave = Integer.parseInt(octave_str,b);
      } catch (NumberFormatException e) {
          JOptionPane.showMessageDialog(this,
            "octave " + octave_str + " is invalid","error",
          JOptionPane.ERROR_MESSAGE);          
          return;
      }
      String generator_str = generator_field.getText();
      int generator = 0;
      try {
        generator = Integer.parseInt(generator_str,b);
      } catch (NumberFormatException e) {
          JOptionPane.showMessageDialog(this,
            "generator " + generator_str + " is invalid","error",
          JOptionPane.ERROR_MESSAGE);          
          return;
      }
      mp.song = song;
      song.octave = octave;
      song.generator = generator; 
      song.base = b;
      n = (Number) max_children_spinner.getValue();
      song.max_children = n.intValue();
      prefs.putInt("base",b);
      prefs.putInt("max_children",song.max_children);
      prefs.put("name",name_field.getText());
      prefs.put("octave",octave_field.getText());
      prefs.put("generator",generator_field.getText());
      //mp.is_playing = false;
      song.create_song(name_field.getText());
      //song.create_random_song(name_field.getText());
      mp.pos = 1.0;
      this.dispose();
    }
    if (action.equals("cancel")) {
      this.dispose();
    }
  }
}
