import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;   
import javax.swing.table.*;
      
import java.awt.*;
import java.awt.event.*;                       
import java.awt.datatransfer.*;

import javax.imageio.*;
import java.awt.image.*;
import java.util.zip.*;
import java.util.prefs.Preferences;

class oscillator_editor_modelc extends  AbstractTableModel {
  public String getColumnName(int column) {
     if (column == 0) {return "pitch";}
     if (column == 1) {return "volume";}
     if (column == 2) {return "phase";}
     return null;
  }
  public int getColumnCount() { 
    return 3;
  }
  public int getRowCount() { 
    return abstract_music_playerc.oscillator_list.size();
  }
  public boolean isCellEditable(int rowIndex,int columnIndex) {
    return true;
  }
  public Object getValueAt(int row, int col) { 
      Harmonic h = (Harmonic) abstract_music_playerc.oscillator_list.get(row);
      if (col == 0) {return new Float(h.freq);}
      if (col == 1) {return new Float(h.vol);}
      if (col == 2) {return new Float(h.phase);}      
      return null;
  }
  public void setValueAt(Object val,int row,int col) {
    Harmonic h = (Harmonic) abstract_music_playerc.oscillator_list.get(row);
    String str = (String) val;
    float f = Float.parseFloat(str);
    Preferences osl_prefs = lsystems_app.prefs.node("oscillator_list");
    if (col == 0) {h.freq = f;osl_prefs.putFloat("freq"+row,f);}
    if (col == 1) {h.vol = f;osl_prefs.putFloat("vol"+row,f);}
    if (col == 2) {h.phase = f;osl_prefs.putFloat("phase"+row,f);}
  }
}
public class oscillator_editorc extends JFrame implements ActionListener {
  JTable table;
  JPanel button_panel; 
  JButton add_button;
  JButton remove_button;
  //JButton update_button;
  JScrollPane listboxscroller;
  oscillator_editorc() {
    table = new JTable(new oscillator_editor_modelc());    
    table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    listboxscroller = new JScrollPane(table);
    
    this.getContentPane().setLayout(new BorderLayout());
    this.getContentPane().add(listboxscroller);

    button_panel = new JPanel();
    this.getContentPane().add(button_panel,BorderLayout.SOUTH);    

    button_panel.setLayout(new GridLayout(1,2));
    add_button = create_button("add","add");
    remove_button = create_button("remove","remove");
    //update_button = create_button("update","update");
    this.setTitle("oscillator editor");
    this.pack();
  }
  void create_new_panel() {
      table.updateUI();
  }
  JButton create_button(String text,String action) {  
    JButton button = new JButton(text);
    button.setActionCommand(action);    
    button.addActionListener(this);
    button_panel.add(button);
    return button;
  }  
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    int ir = table.getSelectedRow();
    if (action.equals("add")) {
      //float h = music_playerc.harmonic_list.size()+1;
      abstract_music_playerc.oscillator_list.add(ir+1,new Harmonic(1.0f,1.0f,0.5f));
    }
    if (action.equals("remove")) {
      abstract_music_playerc.oscillator_list.remove(ir);
    }
    Preferences osl_prefs = lsystems_app.prefs.node("oscillator_list");
    int num_os = abstract_music_playerc.oscillator_list.size();
    osl_prefs.putInt("num_oscillators",num_os);
    for (int i = 0;i < num_os;i++) {
      Harmonic h = (Harmonic) abstract_music_playerc.oscillator_list.get(i);
      osl_prefs.putFloat("freq"+i,h.freq);
      osl_prefs.putFloat("vol"+i,h.vol);
      osl_prefs.putFloat("phase"+i,h.phase);
    }    
    //if (action.equals("update")) {
    //  music_playerc.update();
    //}

  }
  void add_row(int i) {      
    System.out.println("add_row");
  }
}

