import java.awt.*;
public class rule_notec {
  String name;
  long note;
  double freq;
  rule_notec child[] = new rule_notec[3];
  long ratio[] = new long[3];
  rule_notec next;
  lsystems_song parent;

  //rule_notec(double f) {
  //  ratio[0] = 1;
  //  ratio[1] = 1;
  //  ratio[2] = 0;
  //  freq = f;
  //}
  rule_notec(rule_notec r) {
    this.name = r.name;
    this.parent = r.parent;
    int nc = parent.max_children;
    child = new rule_notec[nc];
    ratio = new long[nc];
    for (int i = 0;i < nc;i++) {
      this.ratio[i] = r.ratio[i];
      this.child[i] = r.child[i];
    }
    next = null;
    this.set_note(r.get_note());

  }
  rule_notec(lsystems_song p) {
    next = null;
    parent = p;
    int nc = parent.max_children;
    child = new rule_notec[nc];
    ratio = new long[nc];
    for (int i = 0;i < nc;i++) {
      this.child[i] = this;
      this.ratio[i] = 0;
    }
    this.ratio[0] = 1;
    this.ratio[1] = 1;
    //this.ratio[2] = 0;

  }
  int get_index() {
    int s = parent.p_vec.size();
    for (int i = 0;i < s;i++) {
      if (parent.p_vec.get(i) == this) {return i;}
    }
    return -1;
  }
  String get_ratio_as_string() {
    String s = null;
    int nc = parent.max_children;
    for (int i = 0;i < nc;i++) {
      if (child[i] != null) { 
        if (s != null) {
          s = s + ":" + ratio[i];
        } else {
          s = Long.toString(ratio[i]);
        }
      }
    }
    return s;
  }
  void set_child(int i,String name) {
      int nc = parent.max_children;
      if (i >= nc) {return;}
      if (ratio[i] == 0) {return;}
      rule_notec c = child[i];
        rule_notec c2 = parent.get_rule(name);
        if (c2 == null) {
          c2 = parent.startsWith(name);
        }
        if (c2 != null) {child[i] = c2;}
  }
  String get_child_name(int i) {
    int nc = parent.max_children;
    if (i < nc) {
      if ((child[i] != null) & (ratio[i] != 0)) {return child[i].get_name(parent);}
    }
    return "";
  }

  boolean parse_ratio(String r_string) {
    String I_str[] = r_string.split(":");
    try {
      int j = 0;
      int nc = parent.max_children;
      for (int i = 0;i < nc;i++) {
        //if (child[i] != null) { 
          if (j < I_str.length) { 
            ratio[i] = Long.parseLong(I_str[j]);
            j = j + 1;
          }
        //}
      }
    } catch (NumberFormatException e) {
      return false;
    }
    return true;
  }
  void set_note(long n) {
    note = n;
    lsystems_song p = parent;
    double m = n;
    m = m / p.octave;
    //m = m - Math.floor(m);
    freq = Math.exp(Math.log(2) * m);
  }
  long get_note() {
    return note;
  }
  Color get_note_color() {
    double PI = Math.PI;
    double n = note;
    n = n / parent.octave;
    n = n - Math.floor(n);
    n = n * PI * 2;
    float red = (float) ((Math.sin(n)*0.5)+0.5);
    float green = (float) ((Math.sin(n + ((PI*2)/3.0))*0.5)+0.5);
    float blue = (float) ((Math.sin(n + ((PI*4)/3.0))*0.5)+0.5);
    return new Color(red,green,blue);
  }
  String get_name(lsystems_song s) {
    lsystems_song p = parent;
    String n = name;
    while ((p != s) & (p != null)) {
      if (p.name != null) {
        n = p.name + "." + n;
      }
      p = p.parent;
    }
    return n;
  }

}

