import java.lang.*;
import java.util.*;
import java.io.*;

import javax.sound.sampled.*;



public class sampletablec {
  //float FFT_data[][];
  short sample[];
  int size;
  float wave_length;
  static Random rand = new Random();
  sampletablec(int psize,float wave_length,float bandwidth2,Vector harmonic_list) {
    this.size = 1 << psize;
    this.wave_length = wave_length;
    sample = new short[size+3];
    float FFT_data[][] = new float[size>>1][2];
    float freq = ((float) size) /  wave_length;
    make_instrument_sample(FFT_data,freq,bandwidth2,harmonic_list);
    FFT_Transformc.perform_c2r(FFT_data);
    get_instrument_sample(FFT_data);
    FFT_data = null;
  }  

  void make_instrument_sample(float FFT_data[][],float freq,float bandwidth2,Vector harmonic_list) {
    int num_harmonics = harmonic_list.size();
    int FFT_data_size = FFT_data.length;
    for (int i = 0;i < num_harmonics;i++) {
      Harmonic h = (Harmonic) harmonic_list.get(i);
      float freq2 = freq * h.freq;
      float bandwidth = h.bandwidth * bandwidth2;
      //System.out.println("bandwidth " + bandwidth);
      //System.out.println("h.vol " + h.vol);
      if (freq2 >= (FFT_data_size+bandwidth)) {continue;}
      if (freq2 <= bandwidth) {continue;}
      int start_freq = ((int) (freq2-bandwidth+1.0));
      int end_freq = ((int) (freq2+bandwidth));
      float e_vol = 0;
      for (int i2 = start_freq;i2 <= end_freq;i2++) {        
        float e = (((float) i2)-freq2);
        if (e < 0) {e = -e;} 
        e = 1.0f - (e / bandwidth);   
        if (e < 0) {e = 0.0f;}
        e_vol = e_vol + (e * e);
      }
      for (int i2 = start_freq;i2 <= end_freq;i2++) {        
        float e = (((float) i2)-freq2);
        if (e < 0) {e = -e;} 
        e = 1.0f - (e / bandwidth);   
        if (e < 0) {continue;}
        //e = (e * 1.0f); 
        float am = h.vol / ((float) Math.sqrt(e_vol) * i2);
        float p = (float) (rand.nextFloat()*Math.PI*2.0);
        if (i2 < FFT_data_size) {
          FFT_data[i2][0] = ((float) (Math.cos(p) * e * am));
          FFT_data[i2][1] = ((float) (Math.sin(p) * e * am));
        }
      }
      //if (start_freq > end_freq) {
      //  int i2 = (int) (freq2 + 0.5);
      //  float p = (float) (rand.nextFloat()*Math.PI*2.0);
      //  if (i2 < FFT_data_size) {
      //    FFT_data[i2][0] = ((float) (Math.cos(p) * h.vol));
      //    FFT_data[i2][1] = ((float) (Math.sin(p) * h.vol));
      //  }
      //}
    }
    //System.out.println("FFT_data34 " + FFT_data[FFT_data_size-100][0]);
  }
    
  void get_instrument_sample(float FFT_data[][]) {
    //int clipping = 0;
    double b = 0;
    for (int i = 0;i < size;i++) {
      float a = FFT_data[i >> 1][i & 1];
      if (a < 0) {a = -a;}
      if (a > b) {b = a;}
    }
    for (int i = 0;i < size;i++) {
      double s = (FFT_data[i >> 1][i & 1] / b) * 32767.0;
      //if (s > 127.0) {s = 127.0;clipping++;}
      //if (s < -127.0) {s = -127.0;clipping++;}
      sample[i] = (short) s;
    }
    //System.out.println("clipping: " + clipping);
    for (int i = 0;i < 3;i++) {
    //sample[size] = sample[0]; 
      sample[size+i] = sample[i]; 
    }
  }

}

