import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;   

import java.text.*;
import java.awt.*;
import java.awt.event.*;                       
import java.util.prefs.Preferences;

public class spinner_settings_window extends JFrame implements ChangeListener, ActionListener {
  JSpinner length_spinner;
  JSpinner generations_spinner;
  //JSpinner DC_spinner;
  //JSpinner B_spinner;
  JSpinner key_spinner;
  JSpinner volume_spinner;
  static Preferences prefs = lsystems_app.prefs;

  spinner_settings_window(String Title) {
    super(Title);
    SpinnerNumberModel nm;
    //prefs = Preferences.userRoot().node("lsystems_34987534");

    this.getContentPane().setLayout(new BoxLayout( this.getContentPane(), BoxLayout.PAGE_AXIS));

    Container p = this.getContentPane();
    JPanel button_panel = new JPanel();
    button_panel.setLayout(new GridLayout(1,2));
    button_panel.add(create_button("double"));
    button_panel.add(create_button("half"));
    this.getContentPane().add(button_panel);

    nm = new SpinnerNumberModel(music_playerc.length,1.0,3600.0,1.0);
    length_spinner = create_spinner("length:",nm);

    nm = new SpinnerNumberModel(music_playerc.num_generations,0,100,1);
    generations_spinner = create_spinner("generations:",nm);
    nm = new SpinnerNumberModel(music_playerc.key,-120000,120000,20);
    key_spinner = create_spinner("key:",nm);

    //nm = new SpinnerNumberModel(abstract_music_playerc.DC,0.0,1.0,0.01);
    //DC_spinner = create_spinner("Duty Cycle:",nm);

    //nm = new SpinnerNumberModel(abstract_music_playerc.Bde,0.0,120.0,0.1);
    //B_spinner = create_spinner("B:",nm);

    nm = new SpinnerNumberModel(music_playerc.volume_db,-120,120,1);
    volume_spinner = create_spinner("volume:",nm);
    this.pack();
  }
  JComboBox add_combobox(String text,String[] list) {
    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(1,2));
    panel.add(new JLabel(text));
    JComboBox cb = new JComboBox(list);
    panel.add(cb);
    this.getContentPane().add(panel);
    return cb;
  }
  public JButton create_button(String text) {
    JButton b = new JButton(text);
    b.addActionListener(this);
    b.setActionCommand(text);
    return b;
  }
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    if (action.equals("double")) {
      length_spinner.setValue(new Double(music_playerc.length * 2));
      generations_spinner.setValue(new Double(music_playerc.num_generations + 1));
      key_spinner.setValue(new Integer(music_playerc.key - 1200));
    }
    if (action.equals("half")) {
      length_spinner.setValue(new Double(music_playerc.length / 2));
      generations_spinner.setValue(new Double(music_playerc.num_generations - 1));
      key_spinner.setValue(new Integer(music_playerc.key + 1200));
    }
  }
  public void stateChanged(ChangeEvent e) {
    Number n;
    if (e.getSource() == length_spinner) {
      n = (Number) length_spinner.getValue();
      music_playerc.length = n.doubleValue();
      prefs.putDouble("length",n.doubleValue());
    }
    if (e.getSource() == generations_spinner) {
      n = (Number) generations_spinner.getValue();
      music_playerc.num_generations = n.intValue();
      prefs.putInt("num_generations",n.intValue());

    }
    if (e.getSource() == key_spinner) {
      n = (Number) key_spinner.getValue();
      int key = n.intValue();
      music_playerc.key = key;
      prefs.putInt("key",key);
      abstract_music_playerc.base_freq = Math.exp(Math.log(2) * key / 1200.0)*400;
    }
    //if (e.getSource() == DC_spinner) {
    //  n = (Number) DC_spinner.getValue();
    //  abstract_music_playerc.DC = n.doubleValue();
    //  prefs.putDouble("DC",n.doubleValue());
    //}
    //if (e.getSource() == B_spinner) {
    //  n = (Number) B_spinner.getValue();
    //  double Bde = n.doubleValue();
    //  abstract_music_playerc.Bde = Bde;
    //  abstract_music_playerc.B = Math.exp(Math.exp(-Bde));
    //  prefs.putDouble("B",Bde);
    //}
    if (e.getSource() == volume_spinner) {
      n = (Number) volume_spinner.getValue();
      int db = n.intValue();
      music_playerc.volume_db = db;
      music_playerc.volume = Math.exp(Math.log(10) * (db-85.0) / 20.0);
      prefs.putInt("volume",db);
    }
  
  }
  public JSpinner create_spinner(String text,SpinnerNumberModel m) {
    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(1,2));
    panel.add(new JLabel(text));
    JSpinner sp = new JSpinner(m);
    sp.addChangeListener(this);
    panel.add(sp);
    this.getContentPane().add(panel);
    return sp;
  }
}

