import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; 
import javax.swing.*;                                           
import java.awt.*;
import java.awt.event.*;                       
import javax.imageio.*;
import java.awt.image.*;
import java.util.zip.*;

class main_panelc extends JPanel implements KeyListener,MouseListener, WindowListener {
  Color note_color[] = new Color[7];
  int offset = 0;
  int last_x = 0;
  int last_y = 0;
  int selected_index;
  int ET = 12;
  boolean double_view = false;
  main_panelc() {
    this.addMouseListener(this);
    note_color[0] = Color.red;
    note_color[1] = Color.orange;
    note_color[2] = Color.yellow;
    note_color[3] = Color.green;
    note_color[4] = Color.cyan;
    note_color[5] = Color.blue;
    note_color[6] = new Color(255,0,255);
  }
  protected void paintComponent(Graphics g) {           
    int w = this.getWidth();
    int h = this.getHeight();
    int ET2 = ET;
    if (double_view == true) {ET2 = ET + ET;}
    int s = w / (ET2+1);
    int s2 = main_app.scale_melody_vector.size();
    g.setColor(Color.white);
    g.fillRect(0,0,w,h);
    for (int y = 0;y <= (s2-offset);y++) {
      if ((y*s) > h) {break;}      
      if (y < (s2-offset)) {
        scale_melodyc sm = (scale_melodyc)  main_app.scale_melody_vector.get(y+offset);      
        for (int n = 0;n < 7;n++) {
          int x = sm.get_note_index(n);
          g.setColor(note_color[n]);
          if ((double_view == false) & (x >= ET)) {
            g.fillRect((x-ET)*s,y*s,s,s);            
          } else {
            g.fillRect(x*s,y*s,s,s);
          }
        }      
        main_app.rand.setSeed(sm.seed); 
        paint_random_4colored_squares(g,ET2,y,s);
      }
      int th = 1;
      g.setColor(Color.black);
      if (y == (selected_index-offset)) {
        g.setColor(Color.blue);th = 2;
      }
      if (y == (selected_index-offset+1)) {
        g.setColor(Color.blue);th = 2;
      }
      for (int i = 0;i < th;i++) {
        g.drawLine(0,(y*s)+i,w,(y*s)+i);
      }
    }
    int st = main_app.music_player.song_start-offset;
    g.setColor(Color.green);
    g.drawLine(0,(st*s)-2,w,(st*s)-2);
    g.drawLine(0,(st*s)-1,w,(st*s)-1);
    int e = main_app.music_player.song_end-offset;
    g.setColor(Color.red);
    g.drawLine(0,(e*s)+1,w,(e*s)+1);
    g.drawLine(0,(e*s)+2,w,(e*s)+2);

    g.setColor(Color.black);
    for (int x = 0;x < (ET2+1);x++) {
      int l = (s2-offset)*s;
      if (l > h) {l = h;}
      g.drawLine(x*s,0,x*s,l);
    }    
  }
  void paint_random_4colored_squares(Graphics g,int x,int y,int s) {
      int s2 = s / 2;
      g.setColor(main_app.get_random_color());
      g.fillRect(x*s,y*s,s2,s2);
      g.setColor(main_app.get_random_color());
      g.fillRect((x*s)+s2,y*s,s2,s2);
      g.setColor(main_app.get_random_color());
      g.fillRect(x*s,(y*s)+s2,s2,s2);
      g.setColor(main_app.get_random_color());
      g.fillRect((x*s)+s2,(y*s)+s2,s2,s2);

  }
  public void shift_notes(int s) {
    int ET2 = ET;
    if (double_view == true) {ET2 = ET + ET;}
    scale_melodyc sm = (scale_melodyc)  main_app.scale_melody_vector.get(selected_index);      
    for (int n = 0;n < 7;n++) {
      int i = sm.get_note_index(n);
      int i2 = i - (i % ET2);
      sm.set_note_index(n,i2+((i+s+ET2)%ET2));
    }    
  }

  public void keyPressed(KeyEvent e){
    int a = e.getKeyCode();
    char ch = e.getKeyChar();  
    String s = e.getKeyText(a);
    ch = Character.toLowerCase(ch);
    if (a == KeyEvent.VK_SPACE) {
      main_app.music_player.is_playing = 
      !main_app.music_player.is_playing;
    }
    if (main_app.music_player.is_playing) {
      if (a == KeyEvent.VK_EQUALS) {
         main_app.music_player.volume *= 2; 
      }
      if (a == KeyEvent.VK_PLUS) {
         main_app.music_player.volume *= 2; 
      }
      if (a == KeyEvent.VK_MINUS) {
         main_app.music_player.volume /= 2; 
      }
      if (a == KeyEvent.VK_UNDERSCORE) {
         main_app.music_player.volume /= 2; 
      }
    }
    if (a == KeyEvent.VK_COMMA) {
      shift_notes(-1);
    }
    if (a == KeyEvent.VK_PERIOD) {
      shift_notes(1);
    }
    if (a == KeyEvent.VK_A) {
      scale_melodyc sm = (scale_melodyc)  main_app.scale_melody_vector.get(selected_index);
      int size = main_app.scale_melody_vector.size();
      int end = main_app.music_player.song_end;
      if (size == end) {
        main_app.music_player.song_end++;
      }
      scale_melodyc sm2 = new scale_melodyc(sm);
      main_app.scale_melody_vector.add(selected_index,sm2);
      main_app.song_modified = true;
    }
    if (a == KeyEvent.VK_S) {
      main_app.music_player.song_start = selected_index;
    }
    if (a == KeyEvent.VK_E) {
      main_app.music_player.song_end = selected_index+1;
    }
    if (a == KeyEvent.VK_D) {
      double_view = !double_view;
    }
    if (a == KeyEvent.VK_Q) {
      scale_melodyc sm = (scale_melodyc)  main_app.scale_melody_vector.get(selected_index);
      sm.seed = sm.seed - 1;
    }
    if (a == KeyEvent.VK_W) {
      scale_melodyc sm = (scale_melodyc)  main_app.scale_melody_vector.get(selected_index);
      sm.seed = sm.seed + 1;
    }

    repaint();
  }
  public void keyReleased(KeyEvent e){}
  public void keyTyped(KeyEvent e){}
  public void windowActivated(WindowEvent e){}
  public void windowClosed(WindowEvent e){
    //System.out.println("windowClosed");
  }
  public void windowClosing(WindowEvent e){
    //System.out.println("windowClosing");
    main_app.exit2();  
  }
  public void windowDeactivated(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowOpened(WindowEvent e){}

  public void mouseClicked(MouseEvent e) {}
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void mousePressed(MouseEvent e) {
    int x = e.getX();    
    int y = e.getY();    
    int b = e.getButton();
    int w = this.getWidth();
    int h = this.getHeight();
    int s = w / (ET+1);
    if (double_view == true) {s = w / (ET+ET+1);}
    int x2 = (x / s);
    int y2 = (y / s)+offset;
    selected_index = y2;
    last_x = x2;
    last_y = y2;
  }
  public void mouseReleased(MouseEvent e) {
    int x = e.getX();    
    int y = e.getY();    
    int b = e.getButton();
    int w = this.getWidth();
    int h = this.getHeight();
    int s = w / (ET+1);
    if (double_view == true) {s = w / (ET+ET+1);}
    int ET2 = ET;
    if (double_view == true) {ET2 = ET + ET;}
    int x2 = x / s;
    int y2 = (y / s)+offset;    
    scale_melodyc sm = (scale_melodyc)    main_app.scale_melody_vector.get(last_y);           
    int n2 = -1;
    for (int n = 0;n < 7;n++) {
      if (sm.get_note_index(n) == last_x) {n2 = n;}
    }
    if (x2 < ET2) {
      if (n2 != -1) {sm.set_note_index(n2,x2);}
      else {shift_notes(x2-last_x);}
    }
    if (y2 != last_y) {
       if (y2 >= main_app.scale_melody_vector.size()) {
         y2 = main_app.scale_melody_vector.size()-1;
       }
       main_app.scale_melody_vector.remove(sm);
       main_app.scale_melody_vector.add(y2,sm);
    }
    this.repaint();
  }
}
class scale_melodyc {
  int seed;
  long notes;
  scale_melodyc() {}
  scale_melodyc(scale_melodyc sm) {
    this.seed = sm.seed;
    this.notes = sm.notes;
  }  
  int get_note_index(int n) {
    return (int) ((notes >> (n*9)) & 511);
  }
  void set_note_index(int n,int i) {
    long l = 511;
    notes = notes ^ (notes & (l << (n*9)));
    l = i;
    notes = notes | ((l & 511) << (n*9));
  }
}
class options_dialogc extends JDialog implements ActionListener{
  int num_options;
  JTextField textfield[];
  options_dialogc(Frame owner,String title) {
    super(owner,title,false);
    setBounds(0,0,200,200);
    textfield = new JTextField[20];
    this.getContentPane().setLayout(new GridLayout(2,2));
    add_option("lowest note freq:");
    create_button("ok","ok");
    create_button("cancel","cancel");
  }
  void add_option(String text){
    JLabel label = new JLabel(text);
    this.getContentPane().add(label);
    textfield[num_options] = new JTextField("");
    this.getContentPane().add(textfield[num_options]);
    num_options = num_options + 1;
  }
  JButton create_button(String text,String action) {  
    JButton button = new JButton(text);
    button.setActionCommand(action);    
    button.addActionListener(this);
    this.getContentPane().add(button);
    return button;
  }
  public void show() {
    super.show();
    double base_freq = main_app.music_player.base_freq;
    textfield[0].setText(Double.toString(base_freq));
  }
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    if (action.equals("ok")) {
      this.hide();      
      double base_freq = Double.parseDouble(textfield[0].getText());
      main_app.music_player.base_freq = base_freq;
    }
    if (action.equals("cancel")) {
      this.hide();
    }
  }
}


class main_app implements Runnable,ActionListener,AdjustmentListener {
  static JFrame main_frame;
  static boolean song_modified;
  static main_panelc main_panel;
  static JScrollBar scroll_bar;
  static Vector scale_melody_vector;  
  static Random rand;
  static music_playerc music_player;
  static JMenuBar mainmenu;
  static JMenu filemenu = null;
  static options_dialogc options_dialog;
  public static void main(String[] args)
    throws	Exception
  {    
    rand = new Random();
    scale_melody_vector = new Vector();
    new_song(12);
    javax.swing.SwingUtilities.invokeLater(new main_app());
  }
  static void new_song(int et) {
      scale_melody_vector.clear();
      scale_melodyc sm = new scale_melodyc();
      sm.seed = rand.nextInt(10000);
      int k = rand.nextInt(et);
      int f = (int) (((Math.log(1.5)/Math.log(2))*et)+0.5);
      for (int j = 0;j < 7;j++) {
        sm.set_note_index((j*4)%7,((j+k)*f)%et);
      }
      scale_melody_vector.add(sm);
  }
  static Color get_random_color() {
    int r = rand.nextInt(256);
    int g = rand.nextInt(256);
    int b = rand.nextInt(256);
    return new Color(r,g,b);
  }
  public void run() {    
    setup_menu();
    main_frame = new JFrame();
    main_frame.setJMenuBar(mainmenu);
    main_panel = new main_panelc();
    main_frame.getContentPane().setLayout(new BorderLayout());
    main_frame.getContentPane().add(main_panel);    
    scroll_bar = new JScrollBar();    
    main_frame.getContentPane().add(scroll_bar,BorderLayout.EAST);
    scroll_bar.setOrientation(JScrollBar.VERTICAL);
    scroll_bar.setMaximum(250);
    scroll_bar.addAdjustmentListener(this);
    main_frame.setTitle("frank's java random rainbow music maker program");
    main_frame.addKeyListener(main_panel);
    main_frame.addWindowListener(main_panel);

    main_frame.setBounds(30,30,500,500);
    main_frame.setVisible(true);
    music_player = new music_playerc();
    music_player.start();
  }
  public void adjustmentValueChanged(AdjustmentEvent e) {
    Adjustable a = e.getAdjustable();
    int i = e.getValue();
    main_panel.offset = i;
    main_panel.repaint();
  }
  public void actionPerformed(ActionEvent e) {        
    String action = e.getActionCommand();
    if (action.equals("menunew")) {
      String response = JOptionPane.showInputDialog(main_frame,
      "how many notes per octave do you want?","new song",
      JOptionPane.QUESTION_MESSAGE);
      if (response != null) { 
        int et = Integer.valueOf(response).intValue();
        main_app.new_song(et);main_app.main_panel.ET = et;
        main_app.music_player.notes_per_octave = et;
        main_app.main_panel.repaint();
      }

    }
    if (action.equals("menuopen")) {open2();}
    if (action.equals("menusave")) {save2();}
    if (action.equals("menuoptions")) {
      if (options_dialog == null) {
        options_dialog = new options_dialogc(main_frame,"options");
        options_dialog.setBounds(0,0,200,200);
      }
      options_dialog.setVisible(true);
    }
    if (action.equals("menuexit")) {exit2();}
  }
  JMenuBar setup_menu() {
          JMenuBar mb = new JMenuBar();
          //setup the file menu
          filemenu = new JMenu("file");
          mb.add(filemenu);
          
          JMenuItem minew = new JMenuItem("new");
          filemenu.add(minew);
          minew.setActionCommand("menunew");    
          minew.addActionListener(this);
          
          
          JMenuItem miopen = new JMenuItem("open");
          filemenu.add(miopen);
          miopen.setActionCommand("menuopen");
          miopen.addActionListener(this);
          
          JMenuItem misave = new JMenuItem("save");
          filemenu.add(misave);
          misave.setActionCommand("menusave");
          misave.addActionListener(this);
          
          JMenuItem mioptions = new JMenuItem("options");
          filemenu.add(mioptions);
          mioptions.setActionCommand("menuoptions");
          mioptions.addActionListener(this);
          

          
          JMenuItem miexit = new JMenuItem("exit");
          filemenu.add(miexit);
          miexit.setActionCommand("menuexit");
          miexit.addActionListener(this);
          mainmenu = mb;
          return mainmenu;
  }
  static boolean isFileCompressed(String filename) {
    try{
      FileInputStream f = new FileInputStream(filename);
      int b = f.read();
      int b2 = f.read();
      f.close();
      if (b == 31) {
        if (b2 == 139) {
          return true;
        }
      }
    } catch (Exception err){
      err.printStackTrace();
    }
    return false;
  }
  static String getpath(String filename) {
    String path = "";
    String s = "";
    //int i2 = 0;
    for (int i = 0;i < filename.length();i++) {
      char ch = filename.charAt(i);
      s = s + ch;
      if (ch == File.separatorChar) {
        //i2 = i;
        path = s;
      }
    }
    return path;
  }
  static String getfiletype(String filename){
    String type = "";
    for (int i = filename.length()-1;i >= 0;i--){
      char ch = filename.charAt(i);
      if (ch == '.'){break;}                       
      if (ch == '\\'){break;}
      if (ch == '/'){break;}
      type = ch + type;
    }
    return type;
  }
  static void save2() {
      try{
        FileDialog f = new FileDialog(main_app.main_frame,"save pattern",FileDialog.SAVE);
        f.show();
        if (f.getFile() != null) {
          //filename = f.getFile();
          String filename = f.getDirectory() + f.getFile();
          save(filename);
          
          //cellautoapp.cellautomainwindow.setFocusTraversalKeysEnabled(true);
          main_app.main_frame.repaint();
        }
        main_app.main_frame.requestFocusInWindow();
      } catch (Exception err) {
        System.out.println("menusave error");
        System.out.println(err.getMessage());
        err.printStackTrace();
      }
  }
  static void save(String filename){
    try{
      int l = filename.length();
      if (l > 0){
        String filetype = getfiletype(filename);
        File f = new File(filename);
        if (f.exists() == false){
          if (filetype.equals("gz")) {
            savetext(new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(filename,true)))));
          } else {
            savetext(new BufferedWriter(new FileWriter(filename,true)));
          }
        }else{
          JOptionPane.showMessageDialog(main_app.main_frame,new JLabel("file already exists"),"error",JOptionPane.ERROR_MESSAGE);
        }
      }
    } catch (Exception err){
      System.out.println("menusave error");
      err.printStackTrace();
    }
    updatestatusbar();
    
  }
  static void updatestatusbar(){}
  static void savetext(BufferedWriter w){
    try{
      PrintWriter p = new PrintWriter(w);
      int et = main_app.main_panel.ET;
      double base_freq = music_playerc.base_freq;
      p.println("options," + et + "," + base_freq);
      int s2 = main_app.scale_melody_vector.size();
      for (int y = 0;y < s2;y++) {
        scale_melodyc sm = (scale_melodyc)  main_app.scale_melody_vector.get(y);      
        p.print("sm,"+sm.seed);
        for (int i = 0;i < 7;i++) {
          int n = sm.get_note_index(i);
          p.print(","+n);
        }        
        p.println();
      }
      p.close();
      main_app.song_modified = false;
    } catch (Exception e){
      e.printStackTrace();
    }
  }
  static void open2() {
      try{
        FileDialog f = new FileDialog(main_app.main_frame,"open song",FileDialog.LOAD);
        f.show();
        if (f.getFile() != null) {
          //filename = f.getFile();
          String filename = f.getDirectory() + f.getFile();
          open(filename);
        } else {
          
        }
        main_app.main_frame.requestFocusInWindow();
        main_app.main_frame.repaint();
        
      } catch (Exception err) {
        System.out.println("menuopen error");
        System.out.println(err.getMessage());
        err.printStackTrace();
      }
  }

  static void open(String filename){
    int l = filename.length();
    if (l > 0){      
      try{
        String filetype = getfiletype(filename);
        if (filetype.equals("gz")) {
          boolean c = isFileCompressed(filename);
          if (c == true) {
            opentext(new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)))));
          } else {
            opentext(new BufferedReader(new FileReader(filename)));
          }
        } else {
          opentext(new BufferedReader(new FileReader(filename)));
        }
      } catch (Exception err){
        System.out.println("menuopen error");
        err.printStackTrace();
      }
    }
  }
  static void opentext(BufferedReader r) {
    String line = "";
    int linenum = 0;
    int fileerror = 0;
    try{
      scale_melody_vector.clear();
      line = r.readLine();
      while (line != null){
        linenum = linenum + 1;
        String ss[] = line.split(",");
        String ss2[] = new String[ss.length];
        for (int i = 0;i < ss.length;i++){
          ss2[i] = ss[i];
          ss[i] = ss[i].trim();
        }
        String st = ss[0];
        if (st.equals("options")) {
          int l = ss.length;
          //if (l < 2) {
          int et = Integer.valueOf(ss[1]).intValue();
          //main_app.new_song(et);
          main_app.main_panel.ET = et;
          main_app.music_player.notes_per_octave = et;
          music_playerc.base_freq = Double.valueOf(ss[2]).doubleValue();
          //}
        }
        if (st.equals("sm")) {
          scale_melodyc sm = new scale_melodyc();
          sm.seed = Integer.valueOf(ss[1]).intValue();
          for (int i = 0;i < 7;i++) {
            int n = Integer.valueOf(ss[i+2]).intValue();
            sm.set_note_index(i,n);
          }
          scale_melody_vector.add(sm);
        }
        line = r.readLine();
      }  
      main_app.main_panel.repaint();
      main_app.music_player.song_end = scale_melody_vector.size();
      r.close();
      main_app.song_modified = false;
    } catch (IOException e){
      e.printStackTrace();
    } catch (NumberFormatException e) {
      System.out.println("error: can not read number, line number is " + linenum + " line is ");
      System.out.println(line);
      fileerror = 1;
    }
    
    if (fileerror == 1){
      JOptionPane.showMessageDialog(main_app.main_frame,new JLabel("error: can not open the file, " + "\n" +
        "see the console for details"),"error",JOptionPane.ERROR_MESSAGE);
    }
  }
  static int save_song_prompt() {
    int op = JOptionPane.showConfirmDialog(main_frame,
    "Do you want to save your song?","save song?",
    JOptionPane.YES_NO_OPTION);
    if (op == JOptionPane.YES_OPTION) {
      save2();       
    }    
    return op;
  }

  static void exit2() {
   try{
     if (main_app.music_player.is_playing) {
       main_app.music_player.is_playing = false;
     }
     while (main_app.song_modified == true) {
       //int old_vol = pattern_player.volume;
       //pattern_player.volume = 0;
       int op = save_song_prompt();
       if (op == JOptionPane.NO_OPTION) {
         System.exit(0);
       }
     } 
     System.exit(0);	       
   } catch(SecurityException err){
      System.out.println("can not exit");
   }  
  }
}

