import java.lang.*;
import java.util.*;
import java.io.*;

import javax.sound.sampled.*;

class filterc {
  int size;
  int index;

  double findex;
  double filter[];
  double filter2[];
  double s;
  double am;
  double filtersum;
  double filtersum2;
  double fswitch = 1.0;

  filterc(int size,double s,double am) {
    this.size = size;
    filter = new double[size];
    filter2 = new double[size];
    this.s = s;
    this.am = am;    
  }
  double filter(double f0) {
    index = (index + 1) % size;

    filtersum = filtersum - filter[index];
    filter[index] = filter[index] + ((f0 - filter[index]) * s);
    filtersum = filtersum + filter[index];

    double f1 = filter[index]-(filtersum/size);
    double f2 = ((f1 - filter2[index]) * s);

    filtersum2 = filtersum2 - filter2[index];
    filter2[index] = filter2[index] + f2;
    filtersum2 = filtersum2 + filter2[index];
    //return filter2[index] * am;
    return (filter2[index] - (filtersum2/size)) * am;
    //return (((double)index) / ((double)size));
  }
  double filter2(double f0) {
    index = (index + 1) % size;
    
    filter[index] = filter[index] + ((f0 - filter[index]) * s);
    double f1 = filter[index];
    filter[index] = -filter[index];
    double f2 = ((f1 - filter2[index]) * s);
    filter2[index] = filter2[index] + f2;
    filter2[index] = -filter2[index];
    return -filter2[index];
  }
  void run(double in[],double out[],int bsize) {
    for (int i = 0;i < bsize;i++) {
      out[i] = filter(in[i]);
    }
  }
}
class sampletablec {
  byte sample[]; 
  int size;
  int looppoint;
  int base_wave_length;
  boolean loopon = true;
  double samplerate;
  double env_am_attack;
  double env_am_decay;
  double env_am_sustain;
  double env_am_release;

  sampletablec(int size,int looppoint,double samplerate) {
    this.size = size;
    this.looppoint = looppoint;
    this.samplerate = samplerate;
    this.loopon = true;
    sample = new byte[size+1];
    env_am_attack = 1.0;
    env_am_decay = 0.1;
    env_am_sustain = 1.0;
    env_am_release = 0.1;
  }
  void set_envelope(double a,double d,double s,double r) {
    env_am_attack = a;
    env_am_decay = d;
    env_am_sustain = s;
    env_am_release = r;    
  }
  void output_to_file(String filename) {
    try {
      DataOutputStream outfile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename,true)));
      for (int i = 0;i < size;i++) {
        byte b = sample[i];
        outfile.writeByte(b);
      }
      outfile.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
  void makesampletable_string(int fs) {
    long seed = 5;
    //filter_sinec f = new filter_sinec(100,0.1,1.0);
    filterc f = new filterc(fs,0.1,1.0);
    int clipping = 0;
    samplerate = f.size * 1000.0;
    Random rand = new Random();
    rand.setSeed(seed);
    int i2 = 0;
    double f0 = 0;
    double f3 = 0;

    for (int i = 0;i < (size*2);i++) {
      if (i2 >= (size-looppoint)) {
        rand.setSeed(seed);
        i2 = 0;
      }
      double f1 = (rand.nextDouble()*2.0)-1.0;
      //f0 = f1 * 0.5;
      f0 = f0 + ((f1-f0)*0.005);
      //f3 = f3 + ((f0-f3)*0.005); 
      //double f2 = f.filter(f3*4) * 300;
      double f2 = f.filter(f0) * 400;
      if (f2 > 1.0) {f2 = 1.0;clipping++;}
      if (f2 < -1.0) {f2 = -1.0;clipping++;}
      sample[i2] = ((byte) (f2 * 126));
      i2 = i2 + 1;
    }
    sample[size] = sample[0];
    System.out.println("num times cliped: " + clipping);        
  }
}
class sampleplayerc {
  //double pos;
  //double ipos;
  //boolean playing = false;
  //int mode;
  
  long l_freq;
  long index;
  double freq;
  double cache_freq;
  double vol;
  double vol_step;
  //double am; 
  //double env_am;
  //int note;
  //double env_am_i;
  //int env_am_pharse = 0;
  sampletablec t;
  static double sample_rate = 48000.0;
  sampleplayerc() {
    //this.freq = freq;
    //this.am = am;
    vol = 0.0;
  }
  void note(double freq,double vol,sampletablec t){
    this.freq = freq;
    this.vol = vol;
    this.t = t;
  }
  long get_long_freq(double freq,double s_rate) {
    double f = (freq * s_rate) / (1000.0 * sample_rate);  
    return ((long) (f * 1024.0 * 1024.0 * 4096.0));
  }
  void play(float buf[],int buf_size) {
    if (t == null) {return;}
    if (freq != cache_freq) {
      l_freq = get_long_freq(freq,t.samplerate);
      cache_freq = freq;
    }
    float f0 = 0.000015258789f;
    float f_vol = ((float) vol)*f0;
    float f_vol_inc = ((float) vol_step)*f0;
    int bs = buf_size;
    int i2 = 0;
  //int i3 = 0;
    if (((t.size & (t.size-1)) | t.looppoint) == 0) {
      for (int i = 0;i < bs;i++) {
        i2 = (int) (index >> 32);
        i2 = i2 & (t.size-1);      
        int f2 = (int) ((index >> 16) & 0xFFFF); 
        int f1 = 0xFFFF-f2;
        int s1 = t.sample[i2];
        int s2 = t.sample[i2+1];
        float fs = (float) ((s2*f2)+(s1*f1));
        buf[i] = buf[i] + (fs * f_vol);
        f_vol = f_vol + f_vol_inc;
        index = index + l_freq;
      }  
    } else {
      for (int i = 0;i < bs;i++) {
        i2 = (int) (index >> 32);
        int f2 = (int) ((index >> 16) & 0xFFFF); 
        int f1 = 0xFFFF-f2;
        int s1 = t.sample[i2];
        int s2 = t.sample[i2+1];
        float fs = (float) ((s2*f2)+(s1*f1));
        buf[i] = buf[i] + (fs * f_vol);
        f_vol = f_vol + f_vol_inc;
        index = index + l_freq;
        if (i2 >= t.size) {
          if (t.loopon == false) {
            break;
          }
          long long_table_size = t.size;
          long long_looppoint = t.looppoint;
          index = index - (long_table_size << 32);
          index = index + (long_looppoint << 32);
          i2 = i2 - t.size + t.looppoint;
        }
      }
    }
  }
}

class music_playerc extends Thread {
  Random rand;
  SourceDataLine output_line;
  double volume = 10;
  sampletablec table[];
  sampleplayerc player[][];
  boolean is_playing = false;
  int index1 = 0;
  int index2 = 0;
  int song_start = 0;
  int song_end = 0;
  int notes_per_octave = 12;
  static double base_freq = 16.0;
  music_playerc() {
    rand = new Random();
    output_line = createline(48000);
    table = new sampletablec[8];
    table[7] = new sampletablec(1 << 14,0,8000.0);
    table[7].makesampletable_string(8);
    table[6] = new sampletablec(1 << 14,0,16000.0);
    table[6].makesampletable_string(16);
    table[5] = new sampletablec(1 << 15,0,32000.0);
    table[5].makesampletable_string(32);
    table[4] = new sampletablec(1 << 15,0,64000.0);
    table[4].makesampletable_string(64);
    table[2] = table[4];table[3] = table[4];
    table[0] = table[4];table[1] = table[4];

    player = new sampleplayerc[8][2];
    for (int i = 0;i < 8;i++) {
      for (int ch = 0;ch < 2;ch++) {
        player[i][ch] = new sampleplayerc();
      }
    }
    song_end = main_app.scale_melody_vector.size();
    //player.note(1000.0,0.1,table);
  }
  static double cents_to_freq (double cents) {
    return Math.exp(Math.log(2)*(cents/1200)) * base_freq;
  }
  public SourceDataLine createline(int sample_rate) {
    AudioFormat audioFormat = new AudioFormat((float) sample_rate,16,2,true,true);
    SourceDataLine	line = null;
    DataLine.Info	info = new DataLine.Info(SourceDataLine.class,audioFormat);
    try {
      line = (SourceDataLine) AudioSystem.getLine(info);
      line.open(audioFormat);
    } catch (LineUnavailableException e) {
      e.printStackTrace();
    } catch (Exception e) {
      e.printStackTrace();
    }
    line.start();
    return line;	  
  }
  static int numcliping = 0;
  static int numclipsamples = 0;
  public static double clip(double f0) {
    double f1 = f0;
      if (f1 > 1.0) {
        f1 = 1.0;
        numcliping++;
	//System.out.println("clipping");
      }
      if (f1 < -1.0) {
        f1 = -1.0;
        numcliping++;
        //System.out.println("clipping");
      }
      numclipsamples++;
      if ((numclipsamples >= 10000)) {
	if (numcliping > 0) {
	  //System.out.println("numcliping: " + numcliping);
        }
	numclipsamples = 0;
	numcliping = 0;
      }
      return f1;
  }
  public void run() {
    int bsize = 128;
    float buf[] = new float[bsize];
    float buf2[] = new float[bsize];
    byte abData[] = new byte[bsize*4];
    while (true) {
      if (is_playing) {
        int si = main_app.main_panel.selected_index;
        if (index2 != si) {
          index2 = si;
          index1 = 0;
          
        }
        int st = 6;
        if ((index1 & 1) == 0) {st = 4;}
        if ((index1 & 3) == 0) {st = 2;}
        if ((index1 & 7) == 0) {st = 0;}
        if (index1 == 16) {
          index2 = index2 + 1;
          if (index2 == song_end) {
            index2 = song_start;
          }
          if (index2 >= main_app.scale_melody_vector.size()) {
            index2 = 0;
          }
          main_app.main_panel.selected_index = index2;
          si = index2;
          index1 = 0;
          main_app.main_panel.repaint();
        }
        scale_melodyc sm = (scale_melodyc)     main_app.scale_melody_vector.get(si);
        if ((index1 & 15) == 0) {
          rand.setSeed(sm.seed);
        }
        for (int o = st;o < 8;o++) {
          double f = 0.0;
          double npo = notes_per_octave;
          int n = sm.get_note_index(rand.nextInt(7));
          f = cents_to_freq(((n*1200.0)/npo)+(o*1200.0));
          player[o][0].note(f,0.01,table[o]);
          n = sm.get_note_index(rand.nextInt(7));
          f = cents_to_freq(((n*1200.0)/npo)+(o*1200.0));
          player[o][1].note(f,0.01,table[o]);
        }        
        index1 = index1 + 1;
      }
      for (int i2 = 0;i2 < 200;i2++) {
        for (int i = 0;i < bsize;i++) {
          buf[i] = 0;
          buf2[i] = 0;
        //buf[i] = rand.nextDouble();
        //buf2[i] = rand.nextDouble();
        } 
        if (is_playing) {
          for (int i = 0;i < 8;i++) {
            player[i][0].play(buf,bsize);
            player[i][1].play(buf2,bsize);
          }
        }
        double v = ((double) volume) * 0.01;
        
        for (int i = 0;i < bsize;i++) {
          int ws = ((int) (clip(buf[i]*v) * 32500.0));
	  abData[(i*4)+3] = (byte) (ws & 255);
	  abData[(i*4)+2] = (byte) (ws >> 8);
	 
          ws = ((int) (clip(buf2[i]*v) * 32500.0));	  
	  abData[(i*4)+1] = (byte) (ws & 255);
	  abData[(i*4)+0] = (byte) (ws >> 8);
        }
        output_line.write(abData, 0, bsize* 4);  
      }
    }
  }
}

